/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.Realm;

public class RealmAccessConverter
implements Converter {
    private static Log log = LogFactory.getLog(RealmAccessConverter.class);

    public boolean canConvert(Class type) {
        return type.equals(Realm.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String value = reader.getValue();
        String privateKeyFilename = this.getPrivateKeyFileName(value);
        if (privateKeyFilename == null) {
            return new Realm(this.getSchemes(value), this.getDomains(value), this.getUser(value), this.getHomeDir(value), this.getPassword(value));
        }
        return this.createPrivateKeyRealm(value, privateKeyFilename);
    }

    private Object createPrivateKeyRealm(String value, String privateKeyFN) {
        AccountInfo account = AccountInfo.NO_AUTH_ACCOUNT;
        String publicKeyFN = this.getPublicKeyFileName(value);
        if (publicKeyFN == null) {
            publicKeyFN = privateKeyFN + ".pub";
        }
        try {
            String user = this.getUser(value);
            account = new AccountInfo("Account for user '" + user + "'", user, this.getHomeDir(value), this.getPassword(value), privateKeyFN, publicKeyFN);
        }
        catch (Exception e) {
            log.warn("Unable to read private key file");
        }
        return new Realm(this.getSchemes(value), this.getDomains(value), account);
    }

    private String getSchemes(String value) {
        return value.split("://")[0];
    }

    private String getUser(String value) {
        return this.getCredential(value)[0];
    }

    private String getPassword(String value) {
        return this.getCredential(value)[1];
    }

    private String getPrivateKeyFileName(String value) {
        String[] cred = this.getCredential(value);
        return cred.length > 2 ? cred[2] : null;
    }

    private String getPublicKeyFileName(String value) {
        String[] cred = this.getCredential(value);
        return cred.length > 3 ? cred[3] : null;
    }

    private String getDomains(String value) {
        return this.getLocations(value).split("/")[0];
    }

    private String getHomeDir(String value) {
        String locations = this.getLocations(value);
        int startIndex = locations.indexOf("/");
        return locations.substring(startIndex);
    }

    private String[] getCredential(String value) {
        return this.getCredentialAndLocations(value)[0].split(":");
    }

    private String getLocations(String value) {
        return this.getCredentialAndLocations(value)[1];
    }

    private String[] getCredentialAndLocations(String value) {
        return value.split("://")[1].split("@");
    }
}

