/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import jline.ConsoleReader;
import org.gwe.api.ServerAPI4ClientSession;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.XMLClientAppConfig;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.cmd.ArgsList;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.CredentialNotFoundException;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.Realm;

public class ShellUserInfoCapturingApp {
    public static final String READ_PASS_TOKEN = "?";
    private OutputStream os;
    protected XMLClientAppConfig appConfig;
    private UserInfo user = null;
    private ServerAPI4ClientSession session = null;
    private boolean passwordConfirmation;
    protected ConsoleReader consoleReader;

    public ShellUserInfoCapturingApp(OutputStream os, int index, ArgsList argsList) throws CredentialNotFoundException, ClusterNotSpecifiedException, IOException {
        this(os, argsList.extractArgIfPrefixed(index, "-login="), argsList.extractArgIfPrefixed(index, "-conf="));
    }

    public ShellUserInfoCapturingApp(OutputStream os, String loginArg, String confArg) throws CredentialNotFoundException, ClusterNotSpecifiedException, IOException {
        this.os = os;
        this.appConfig = new XMLClientAppConfig(loginArg, confArg);
        this.consoleReader = new ConsoleReader();
    }

    public void enablePasswordConfirmation() {
        this.passwordConfirmation = true;
    }

    public ServerAPI4ClientSession getSession() {
        try {
            if (this.session == null) {
                this.session = this.appConfig.createLoggedInSession(this.getGWEUser());
            }
        }
        catch (PasswordMismatchException e) {
            this.exit("Authentication failure. Password for user " + this.getGWEUser().getId() + " does not match the one on file");
        }
        catch (RemoteException e) {
            this.exit("Problems encountered trying to log in user. " + e.getMessage());
        }
        catch (ServerAPIConnectionException e) {
            this.exit(e.getMessage());
        }
        return this.session;
    }

    public UserInfo getGWEUser() {
        if (this.user == null) {
            this.readKeyStorePasswords(this.appConfig.getKeys());
            this.user = this.appConfig.getGwePassword() != null ? new UserInfo(this.appConfig.getGweUser(), this.appConfig.getGwePassword()) : this.createUserInfo();
        }
        return this.user;
    }

    private UserInfo createUserInfo() {
        try {
            String username = this.appConfig.getGweUser() != null ? this.appConfig.getGweUser() : this.consoleReader.readLine("GWE User: ");
            String password = this.readMasked(username + "'s password: ");
            return new UserInfo(username, password);
        }
        catch (IOException e) {
            this.exit("Could not read user name from console");
            return null;
        }
    }

    private void readKeyStorePasswords(KeyStore keys) {
        boolean started = false;
        for (Realm realm : keys.getRealms()) {
            AccountInfo acct = realm.getAccount();
            String leadingPrompt = acct.getUserName() + "@" + realm.toString() + " ";
            if (acct.missingPassword()) {
                started = this.startInput(started);
                acct.setPassword(this.readMasked(leadingPrompt + "password: "));
            }
            if (!acct.missingPassphrase()) continue;
            started = this.startInput(started);
            acct.setPassphrase(this.readMasked(leadingPrompt + "passphrase: "));
        }
        this.println("============================================\n");
    }

    private boolean startInput(boolean started) {
        if (!started) {
            this.println("ENTER KEYSTORE (gwe-auth.xml) MISSING VALUES\n============================================");
        }
        return true;
    }

    private String readMasked(String prompt) {
        try {
            boolean passwordCaptured = false;
            String valueRead = null;
            while (!passwordCaptured) {
                String confirmation = this.passwordConfirmation ? this.consoleReader.readLine("confirm " + prompt, Character.valueOf('*')) : valueRead;
                passwordCaptured = confirmation.equals(valueRead = this.consoleReader.readLine(prompt, Character.valueOf('*')));
                if (passwordCaptured) continue;
                this.println("Passwords do not match!");
            }
            return valueRead;
        }
        catch (IOException e) {
            this.exit("Could not read password from console");
            return null;
        }
    }

    protected void exit(String message) {
        this.println(message + ".\nExiting.");
        System.exit(0);
    }

    protected void println(String msg) {
        this.print(msg + "\n");
    }

    protected void print(String msg) {
        if (this.os == null) {
            return;
        }
        try {
            this.os.write(msg.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

