/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.gwe.app.client.ClientAppConfig;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.RealmAccessConverter;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.utils.cmd.OptionParser;
import org.gwe.utils.security.CredentialNotFoundException;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.Realm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLClientAppConfig
extends ClientAppConfig {
    public static final String CONF_ARG_PREFIX = "-conf=";
    public static final String DEFAULT_GRID_FILENAME = "gwe-grid.xml";
    public static final String DEFAULT_KEYS_FILENAME = "gwe-auth.xml";
    private String daemonName = null;
    private String gridFN = "gwe-grid.xml";
    private String keysFN = "gwe-auth.xml";

    public XMLClientAppConfig(String loginArg, String confArg) throws FileNotFoundException, CredentialNotFoundException, ClusterNotSpecifiedException {
        this(XMLClientAppConfig.extractGWE_HOME(), loginArg, confArg);
    }

    public XMLClientAppConfig(String gweHome, String loginArg, String confArg) throws FileNotFoundException, CredentialNotFoundException, ClusterNotSpecifiedException {
        super(gweHome, loginArg);
        OptionParser option = new OptionParser(CONF_ARG_PREFIX, loginArg, new char[]{'@', ':'});
        this.daemonName = option.getEle(0, this.daemonName);
        this.gridFN = option.getEle(1, this.gridFN);
        this.keysFN = option.getEle(2, this.keysFN);
        KeyStore keys = this.readXMLObject(this.keysFN, KeyStore.class, Realm.class, "keystore", "realms", "realm-access");
        GridInfo grid = this.readXMLObject(this.gridFN, GridInfo.class, HeadResourceInfo.class, "grid", "headResources", "cluster");
        HeadResourceInfo daemonInfo = grid.getHeadResource(this.daemonName);
        if (daemonInfo == null && grid.getHeadResources().size() > 0) {
            daemonInfo = grid.getHeadResources().get(0);
        }
        if (daemonInfo != null && daemonInfo.getRegistryPort() == 0) {
            daemonInfo.setRegistryPort(1099);
        }
        this.load(daemonInfo, keys, grid);
    }

    private <RESULT_TYPE> RESULT_TYPE readXMLObject(String fileName, Class<RESULT_TYPE> parentClass, Class childClass, String parentAlias, String collectionPropName, String childAlias) throws FileNotFoundException {
        XStream result = new XStream(new DomDriver());
        result.alias(parentAlias, parentClass);
        result.alias(childAlias, childClass);
        result.addImplicitCollection(parentClass, collectionPropName);
        result.registerConverter(new RealmAccessConverter());
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (is == null) {
            is = new FileInputStream(new File(fileName));
        }
        return (RESULT_TYPE)result.fromXML(is);
    }
}

