/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.admin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.api.DaemonAppTemplate;
import org.gwe.app.client.ClientAppConfig;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.bundleManagers.BundleHandle;
import org.gwe.drivers.bundleManagers.BundleType;
import org.gwe.drivers.bundleManagers.GridBundleManager;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.osAppManagers.GridOSAppManager;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.osAppManagers.LaunchFailedException;
import org.gwe.drivers.osAppManagers.MainClass;
import org.gwe.drivers.osAppManagers.OSAppFolder;
import org.gwe.utils.cmd.OptionTemplate;
import org.gwe.utils.security.URILink;

public class DaemonAppManager {
    private static Log log = LogFactory.getLog(DaemonAppManager.class);
    private static final String DAEMON_APP_CONFIGURED_MESSAGE = "DAEMON_CONFIGURED_SUCCESSFULLY";
    private static final String DAEMON_APP_READY_MESSAGE = "DAEMON_READY_TO_SERVE_REQUESTS";
    private GridBundleManager bundleMgr;
    private GridOSAppManager appMgr;
    private ClientAppConfig appConfig;

    public DaemonAppManager(ClientAppConfig cfg) {
        this.appConfig = cfg;
        this.bundleMgr = GWEAppContext.getInstance().getBeanOfClass(GridBundleManager.class);
        this.appMgr = GWEAppContext.getInstance().getBeanOfClass(GridOSAppManager.class);
        JavaOSAppHandle osApp = this.appMgr.createHandle(cfg.getNodeAccount().getHomeDir(), MainClass.DAEMON, true);
        this.appConfig.getClusterSelected().setDaemonOSApp(osApp);
    }

    public ClientAppConfig getAppConfig() {
        return this.appConfig;
    }

    public void installDaemon() throws Exception {
        this.installDaemon(null);
    }

    public void installDaemon(String sourceFolder) throws Exception {
        if (this.deployDaemon(sourceFolder)) {
            this.configureDaemon();
        }
    }

    public boolean deployDaemon(String sourceFolder) throws Exception {
        URILink destLink = this.appConfig.getNodeLink();
        if (sourceFolder == null || "".equals(sourceFolder)) {
            sourceFolder = OSAppFolder.BUNDLES.getUserDirRelative();
        }
        JavaOSAppHandle daemonOSApp = this.appConfig.getClusterSelected().getDaemonOSApp();
        BundleHandle bundle = this.bundleMgr.createHandle(BundleType.ZIP, sourceFolder, daemonOSApp.getVersionedName("-daemon"));
        return bundle.deploy(destLink, daemonOSApp.getFolderFullPath(OSAppFolder.ROOT), daemonOSApp.getFolderFullPath(OSAppFolder.HOME), this.appConfig.getKeys());
    }

    public void configureDaemon() throws HandleOperationException, ConnectorException, LaunchFailedException {
        URILink destLink = this.appConfig.getNodeLink();
        String filePath = this.appConfig.getClusterSelected().getLinkSerializedFilePath();
        String destFile = destLink.createFSURI(filePath);
        GWEAppContext.getGridFileSystem().createHandle(destFile, this.appConfig.getKeys()).storeObject(destLink);
        this.executeDaemonRemotely(true);
    }

    public void launchDaemon() throws HandleOperationException, ConnectorException, LaunchFailedException {
        this.executeDaemonRemotely(false);
    }

    private void executeDaemonRemotely(boolean configMode) throws HandleOperationException, ConnectorException, LaunchFailedException {
        JavaOSAppHandle daemonOSApp = this.appConfig.getClusterSelected().getDaemonOSApp();
        String exitToken = configMode ? DAEMON_APP_CONFIGURED_MESSAGE : DAEMON_APP_READY_MESSAGE;
        Object[] args = new DaemonAppTemplate(new OptionTemplate[0]).createAppArgs(configMode, this.appConfig.getClusterSelected(), exitToken);
        daemonOSApp.setArgs(args);
        daemonOSApp.launch(this.appConfig.getNodeLink(), 120000, exitToken);
    }
}

