/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import org.gwe.api.ServerAPI4UserAdmin;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.api.exceptions.UserIsNotDaemonAdminException;
import org.gwe.app.client.ClientAppConfig;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.GWEASCIILogo;
import org.gwe.app.client.ShellUserInfoCapturingApp;
import org.gwe.app.client.admin.DaemonAppManager;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.osAppManagers.LaunchFailedException;
import org.gwe.drivers.osAppManagers.OSAppFolder;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.cmd.ArgsList;
import org.gwe.utils.security.CredentialNotFoundException;

public class DaemonSetupApp
extends ShellUserInfoCapturingApp {
    private DaemonAppManager daemonAppManager;

    public static void main(String[] args) {
        try {
            boolean installSelected = DaemonSetupApp.isActionChosen(args, "install");
            boolean launchSelected = DaemonSetupApp.isActionChosen(args, "launch");
            new DaemonSetupApp(1, new ArgsList(args), installSelected, launchSelected, (OutputStream)System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static boolean isActionChosen(String[] args, String action) {
        return args.length > 0 && args[0].contains(action);
    }

    public DaemonSetupApp(String loginArg, String confArg, boolean install, boolean launch, OutputStream os4Msgs) throws CredentialNotFoundException, ClusterNotSpecifiedException, IOException {
        super(os4Msgs, loginArg, confArg);
        this.init(install, launch);
    }

    public DaemonSetupApp(int index, ArgsList argsList, boolean install, boolean launch, OutputStream os4Msgs) throws CredentialNotFoundException, ClusterNotSpecifiedException, IOException {
        super(os4Msgs, index, argsList);
        this.init(install, launch);
    }

    private void init(boolean install, boolean launch) throws IOException {
        if (install) {
            this.enablePasswordConfirmation();
        }
        this.daemonAppManager = new DaemonAppManager(this.appConfig);
        UserInfo user = this.gatherGWEUser(install, launch);
        this.println("Initializing application...");
        if (install) {
            this.installDaemon();
        }
        if (launch) {
            boolean launched = this.launchDaemon(user, !install);
            this.println(launched ? "GWE daemon running and ready!" : "GWE daemon could not be launched.");
        }
    }

    private UserInfo gatherGWEUser(boolean install, boolean launch) throws IOException {
        HeadResourceInfo cluster = this.daemonAppManager.getAppConfig().getClusterSelected();
        String actions = install ? (launch ? "install and launch" : "install") : (launch ? "launch" : "");
        this.println("==============================================================");
        this.println(GWEASCIILogo.prefixLogo("         __      __       \n    ____/  \\    /  \\___   \n   / __ \\   \\/\\/   /__ \\  \n  / /_/  \\        / \\_\\ \\ \n  \\___  / \\__/\\__/\\  ___/ \n /_____/           \\_____\\", "\t") + "\n");
        this.println("\tWelcome to GWE Daemon Setup");
        this.println("\tYou have chosen to " + actions + " a GWE daemon\n");
        this.println("\t\tGWE daemon descriptor selected: '" + cluster.getName() + "'");
        this.println("\t\tHost: " + cluster.getHost() + "");
        this.println("\t\tIP Port: " + cluster.getRegistryPort() + "");
        this.println("\t\tQueue Size: " + cluster.getQueueSize() + " nodes");
        this.println("\t\tHijack Timeout: " + cluster.getMaxHijackMillis() / 1000L + " seconds");
        this.println("\t\tIdle Timeout: " + cluster.getMaxIdleMillis() / 1000L + " seconds");
        this.println("\n==============================================================\n");
        return this.getGWEUser();
    }

    public boolean installDaemon() {
        boolean newlyDeployed;
        String homeFolder = ClientAppConfig.extractGWE_HOME();
        if (homeFolder == null) {
            this.println("'GWE_HOME' environment variable not set. Unable to locate GWE distribution to install. Exiting.");
            return false;
        }
        String separator = System.getProperty("file.separator");
        if (!homeFolder.endsWith(separator)) {
            homeFolder = homeFolder + separator;
        }
        this.println("Deploying bundle containing GWE daemon's distribution (this may take a few minutes)...");
        try {
            newlyDeployed = this.daemonAppManager.deployDaemon(OSAppFolder.BUNDLES.getDirRelative(homeFolder));
        }
        catch (HandleOperationException e) {
            this.println("GWE daemon failed to launch. Problems establishing network connection to remote compute node.\n\t" + e.getMessage());
            return false;
        }
        catch (ConnectorException e) {
            this.println("GWE daemon failed to launch. Problems executing command to unbundle GWE distribution on remote compute node.\n\t" + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.println("GWE daemon failed to deploy. Problems transfering GWE distribution bundle to remote compute node.\n\t" + e.getMessage());
            return false;
        }
        if (!newlyDeployed) {
            this.println("GWE daemon was already deployed.");
        } else {
            this.println("GWE daemon deployed. Configuring GWE daemon (this may take a few minutes)...");
            try {
                this.daemonAppManager.configureDaemon();
            }
            catch (Exception e) {
                this.processSystemException("configure", e);
                return false;
            }
            this.println("GWE daemon fully installed and ready to be launched.");
        }
        return true;
    }

    public boolean launchDaemon(UserInfo admin, boolean tryToStartFirst) {
        ServerAPI4UserAdmin link;
        ServerAPIAccessor accessor = this.daemonAppManager.getAppConfig().createAPIAccessor();
        if (tryToStartFirst && (link = this.createAdminLink(accessor)) != null) {
            return this.startDaemon(admin, link);
        }
        this.println("Launching GWE daemon (this may take a few minutes)...");
        try {
            this.daemonAppManager.launchDaemon();
            this.println("GWE daemon launched.");
        }
        catch (LaunchFailedException e) {
            this.processSystemException("launch", e);
        }
        catch (Exception e) {
            this.processSystemException("launch", e);
            return false;
        }
        link = this.createAdminLink(accessor);
        return link != null && this.startDaemon(admin, link);
    }

    private ServerAPI4UserAdmin createAdminLink(ServerAPIAccessor accessor) {
        try {
            return accessor.createLink(ServerAPI4UserAdmin.class);
        }
        catch (Exception e) {
            this.println("Unable to contact GWE daemon OS process. It may not be running.");
            return null;
        }
    }

    private boolean startDaemon(UserInfo admin, ServerAPI4UserAdmin link) {
        this.println("Trying to start GWE daemon services...");
        try {
            link.startDaemon(admin);
            return true;
        }
        catch (UndeclaredThrowableException e) {
            this.processStartDaemonException(e.getUndeclaredThrowable());
        }
        catch (Exception e) {
            this.processStartDaemonException(e);
        }
        return false;
    }

    private void processStartDaemonException(Throwable exc) {
        if (exc instanceof PasswordMismatchException || exc instanceof UserIsNotDaemonAdminException) {
            this.println("GWE daemon refused to start. User provided couldn't be authenticated as daemon's admin. User is not GWE daemon's admin or the password is incorrect.");
        } else {
            this.println("GWE daemon failed to start. Most likely another instance is already running.");
        }
    }

    private void processSystemException(String action, Exception e) {
        String mainMsg = "GWE daemon failed to " + action + ". ";
        if (e instanceof HandleOperationException) {
            this.println(mainMsg + "Problems accessing remote compute node.\n\t" + e.getMessage());
        } else if (e instanceof ConnectorException) {
            this.println(mainMsg + "Problems executing launchable command on remote compute node.\n\t" + e.getMessage());
        } else if (e instanceof LaunchFailedException) {
            this.println(mainMsg + "Most likely an instance of GWE daemon is already running on the target remote compute node.");
        }
    }
}

