/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.regular.shell;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.ClientOrderBasedOperation;
import org.gwe.api.ClientOrderBasedQuery;
import org.gwe.api.ServerAPI4ClientSession;
import org.gwe.api.ServerAPIConnectionException;
import org.gwe.api.exceptions.GWEDomainException;
import org.gwe.api.exceptions.GridNotFoundException;
import org.gwe.api.exceptions.GridNotSpecifiedException;
import org.gwe.api.exceptions.OrderNotSpecifiedException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.ShellUserInfoCapturingApp;
import org.gwe.p2el.P2ELStatement;
import org.gwe.p2el.P2ELSyntaxException;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.order.shell.VelocityJobsDescriptor;
import org.gwe.utils.StringUtils;
import org.gwe.utils.cmd.ArgsList;
import org.gwe.utils.security.CredentialNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellApp
extends ShellUserInfoCapturingApp {
    private static Log log = LogFactory.getLog(ShellApp.class);

    public ShellApp(int index, ArgsList argsList) throws CredentialNotFoundException, ClusterNotSpecifiedException, IOException {
        super((OutputStream)System.out, index, argsList);
    }

    protected String processCommand(String[] args) {
        try {
            return this.processCommandInternal(args);
        }
        catch (ServerAPIConnectionException e) {
            return e.getMessage();
        }
        catch (RemoteException e) {
            return "Unexpected error encountered on the daemon: " + e.getMessage();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    protected String processCommandInternal(String[] args) throws ServerAPIConnectionException, P2ELSyntaxException, PasswordMismatchException, OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException, RemoteException, GWEDomainException {
        String cmdName = args[0];
        String[] actualArgs = StringUtils.removeArgs(args, 0, 1);
        String output = "Command '" + cmdName + "' not supported";
        ServerAPI4ClientSession session = this.getSession();
        if ("queue-order".equals(cmdName)) {
            P2ELStatement stmt = this.appConfig.createStatement(StringUtils.getArrayAsStr(actualArgs));
            OrderInfo order = new OrderInfo(new VelocityJobsDescriptor(stmt));
            output = "Order queued with id " + session.queueOrder(order);
        }
        if (ClientOrderBasedQuery.getQuery(cmdName) != null) {
            output = session.doOrderBasedQuery(ClientOrderBasedQuery.getQuery(cmdName), this.getIdArg(0, actualArgs), this.getIdArg(1, actualArgs));
        }
        if (ClientOrderBasedOperation.getOperation(cmdName) != null) {
            output = session.doOrderBasedOperation(ClientOrderBasedOperation.getOperation(cmdName), this.getIdArg(0, actualArgs));
        }
        return output;
    }

    protected List<String> getCommandList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("queue-order");
        result.addAll(ClientOrderBasedOperation.getOperations());
        result.addAll(ClientOrderBasedQuery.getQueries());
        return result;
    }

    private int getIdArg(int idx, String[] args) {
        try {
            return idx > args.length - 1 ? -1 : Integer.parseInt(args[idx]);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Argument '" + args[idx] + "' is not an integer");
        }
    }
}

