/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.regular.shell;

import java.io.IOException;
import java.rmi.RemoteException;
import jline.ArgumentCompletor;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.NullCompletor;
import jline.SimpleCompletor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.app.client.ClusterNotSpecifiedException;
import org.gwe.app.client.GWEASCIILogo;
import org.gwe.app.client.regular.shell.ShellApp;
import org.gwe.utils.StringUtils;
import org.gwe.utils.cmd.ArgsList;
import org.gwe.utils.security.CredentialNotFoundException;

public class TerminalShellApp
extends ShellApp {
    private static Log log = LogFactory.getLog(TerminalShellApp.class);
    private boolean connected = false;
    private String connURL = this.getSession().getUsername() + "@" + this.appConfig.getConnectionURL(false);

    public static void main(String[] args) throws IOException, CredentialNotFoundException, ClusterNotSpecifiedException {
        try {
            TerminalShellApp app = new TerminalShellApp(0, new ArgsList(args));
            app.runTerminal();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TerminalShellApp(int index, ArgsList argsList) throws RemoteException, CredentialNotFoundException, ClusterNotSpecifiedException, IOException {
        super(index, argsList);
    }

    public void runTerminal() throws IOException {
        this.outputTerminalHeader();
        this.consoleReader.addCompletor(new ArgumentCompletor(new Completor[]{new SimpleCompletor(this.getCommandList().toArray(new String[0])), new NullCompletor()}));
        ((CandidateListCompletionHandler)this.consoleReader.getCompletionHandler()).setAlwaysIncludeNewline(false);
        String line;
        while ((line = this.consoleReader.readLine("GWE [" + this.connURL + "] " + (this.connected ? "> " : "? "))) != null) {
            String[] cmd = StringUtils.splitSpaceSeparated(line);
            if (cmd.length == 0) continue;
            String cmdName = cmd[0];
            if (cmdName.equalsIgnoreCase("exit") || cmdName.equalsIgnoreCase("quit")) {
                this.println("Disconnecting...\nBye!");
                System.exit(0);
            }
            try {
                this.println(this.processCommand(cmd));
                this.connected = true;
                continue;
            }
            catch (Exception e) {
                this.println("Command failed: [" + e.getMessage() + "]\n");
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
        return;
    }

    private void outputTerminalHeader() {
        this.println("================================================");
        this.println(GWEASCIILogo.prefixLogo("         __      __       \n    ____/  \\    /  \\___   \n   / __ \\   \\/\\/   /__ \\  \n  / /_/  \\        / \\_\\ \\ \n  \\___  / \\__/\\__/\\  ___/ \n /_____/           \\_____\\", "\t") + "\n");
        this.println("\tWelcome to GWE Terminal.");
        this.connected = true;
        this.println("\tYou are connected to " + this.connURL + ".");
        this.println("\n================================================\n\n");
    }
}

