/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.regular.swing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.gwe.app.client.regular.swing.JobDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppModel {
    private static AppModel instance = null;
    protected Map<String, List<JobDetails>> orders = new HashMap<String, List<JobDetails>>();
    protected JTable jobsTable;
    protected String selOrderId;
    protected JComboBox ordersCombo;
    protected JTextArea txtArea;
    protected JComboBox clustersCombo;

    public static void init(AppModel inst) {
        instance = inst;
    }

    public static AppModel getInstance() {
        return instance;
    }

    protected AppModel() {
    }

    public void setJobsTable(JTable jobsTable) {
        this.jobsTable = jobsTable;
    }

    public void setOrdersCombo(JComboBox ordersCombo) {
        this.ordersCombo = ordersCombo;
    }

    public void setClustersCombo(JComboBox clustersCombo) {
        this.clustersCombo = clustersCombo;
    }

    public void defineCluster(String name, String host, int maxCN, long maxHijack, long maxIdle) {
        this.clustersCombo.setModel(new DefaultComboBoxModel<Object>(this.defineClusterInternal(name, host, maxCN, maxHijack, maxIdle)));
    }

    protected abstract Object[] defineClusterInternal(String var1, String var2, int var3, long var4, long var6);

    public void submitOrder(final String user, final String password, final String clusterName, final boolean autoInstall, final String script, final boolean isLDDMMOrder, final JTextArea txtArea) {
        this.txtArea = txtArea;
        new Thread(new Runnable(){

            public void run() {
                txtArea.setText("");
                AppModel.this.submitOrderInternal(user, password, clusterName, autoInstall, script, isLDDMMOrder);
            }
        }).start();
    }

    private List<JobDetails> addNewOrder(String orderId) {
        ArrayList<JobDetails> jobs = new ArrayList<JobDetails>();
        this.orders.put(orderId, jobs);
        this.ordersCombo.setModel(new DefaultComboBoxModel<Object>(this.orders.keySet().toArray()));
        this.ordersCombo.setSelectedItem(this.selOrderId);
        return jobs;
    }

    public void appendOrderSubmissionProgress(String message) {
        this.txtArea.setText(this.txtArea.getText() + message);
    }

    protected abstract int submitOrderInternal(String var1, String var2, String var3, boolean var4, String var5, boolean var6);

    public void setMonitoredOrderId(String orderId) {
        this.selOrderId = orderId;
        this.refreshJobsTable(orderId);
    }

    public JobDetails getJobDetails(String orderId, String jobId) {
        List<JobDetails> order = this.orders.get(orderId);
        if (order == null) {
            order = this.addNewOrder(orderId);
        }
        for (JobDetails jd : order) {
            if (!jd.getId().equals(jobId)) continue;
            return jd;
        }
        JobDetails result = new JobDetails(jobId);
        order.add(result);
        return result;
    }

    public void refreshJobsTable(String orderId) {
        if (this.selOrderId == null || !this.selOrderId.equals(orderId)) {
            return;
        }
        ArrayList<Object[]> detailsAsArray = new ArrayList<Object[]>();
        for (JobDetails job : this.orders.get(orderId)) {
            detailsAsArray.add(job.getAsRow());
        }
        Object[][] tableData = (Object[][])detailsAsArray.toArray((T[])new Object[0][]);
        this.jobsTable.removeAll();
        this.jobsTable.setModel(new DefaultTableModel(tableData, new String[]{"Job Id", "Details", "Waiting", "Preparing", "Running", "Done", "Results"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        this.jobsTable.getColumnModel().getColumn(0).setMinWidth(60);
        this.jobsTable.getColumnModel().getColumn(0).setMaxWidth(60);
        this.jobsTable.getColumnModel().getColumn(2).setMinWidth(50);
        this.jobsTable.getColumnModel().getColumn(2).setMaxWidth(50);
        this.jobsTable.getColumnModel().getColumn(3).setMinWidth(60);
        this.jobsTable.getColumnModel().getColumn(3).setMaxWidth(60);
        this.jobsTable.getColumnModel().getColumn(4).setMinWidth(50);
        this.jobsTable.getColumnModel().getColumn(4).setMaxWidth(50);
        this.jobsTable.getColumnModel().getColumn(5).setMinWidth(50);
        this.jobsTable.getColumnModel().getColumn(5).setMaxWidth(50);
    }
}

