/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.regular.swing;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.gwe.GWEAppContext;
import org.gwe.api.EventMonitor;
import org.gwe.api.ServerAPI4UserRegular;
import org.gwe.api.ServerAPIAccessor;
import org.gwe.api.event.DefaultEventFilter;
import org.gwe.app.client.ClientAppConfig;
import org.gwe.app.client.XMLClientAppConfig;
import org.gwe.app.client.regular.swing.AppModel;
import org.gwe.app.client.regular.swing.RichEventListener;
import org.gwe.app.client.regular.swing.RichProgressTracker;
import org.gwe.p2el.P2ELExpressionContext;
import org.gwe.p2el.P2ELStatement;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.persistence.model.order.shell.ShellCommandDaemonRequest;
import org.gwe.persistence.model.order.shell.VelocityJobsDescriptor;
import org.gwe.utils.security.KeyStore;

public class RichAppModel
extends AppModel {
    private ServerAPI4UserRegular coordinator = null;
    private List<HeadResourceInfo> clusters = new ArrayList<HeadResourceInfo>();
    private KeyStore keys;
    private EventMonitor monitor;
    private ServerAPIAccessor accessor;
    private RichProgressTracker tracker;

    public RichAppModel() {
        try {
            XMLClientAppConfig cfg = new XMLClientAppConfig(null, null);
            this.keys = null;
            this.accessor = cfg.createAPIAccessor();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected int submitOrderInternal(String userName, String password, String clusterName, boolean autoInstall, String script, boolean isLDDMMOrder) {
        this.tracker = new RichProgressTracker(this.txtArea);
        UserInfo user = new UserInfo(userName, password);
        try {
            P2ELStatement stmt = GWEAppContext.getP2ELEngine().createStatement(new P2ELExpressionContext(null, this.keys), script);
            VelocityJobsDescriptor jd = new VelocityJobsDescriptor(stmt);
            jd.setDaemonRequestClass(ShellCommandDaemonRequest.class);
            OrderInfo order = new OrderInfo(jd);
            HeadResourceInfo daemonInfo = this.getCluster(clusterName);
            if (this.coordinator == null) {
                this.connect(user, daemonInfo);
            }
            GridInfo grid = this.getDefinedGridFor(user, daemonInfo);
            this.tracker.trackProgress("Requesting order processing...");
            int id = this.coordinator.queueOrder(user, grid.getId(), order);
            this.tracker.trackProgress("Order accepted by daemon. Tracking id: " + id);
            return id;
        }
        catch (Exception e) {
            this.tracker.trackProgress("Problem encountered while preparing to submit the order: " + e.getMessage());
            this.tracker.shutdown();
            return 0;
        }
    }

    private void connect(UserInfo user, HeadResourceInfo daemonInfo) throws Exception {
        ClientAppConfig appConfig = new ClientAppConfig(null);
        appConfig.load(daemonInfo, this.keys, new GridInfo[0]);
        this.coordinator = this.accessor.createLink(ServerAPI4UserRegular.class);
        this.tracker.trackProgress("Connecting to monitoring service...");
        this.monitor = this.accessor.createEventMonitor();
        this.tracker.trackProgress("Registering interest in ALL occurring events ...");
        this.monitor.monitorEvents(new RichEventListener(this), new DefaultEventFilter(null));
    }

    private GridInfo getDefinedGridFor(UserInfo user, HeadResourceInfo daemonInfo) throws RemoteException {
        return null;
    }

    private HeadResourceInfo getCluster(String name) {
        for (HeadResourceInfo cl : this.clusters) {
            if (!name.equals(cl.getName())) continue;
            return cl;
        }
        return null;
    }

    protected Object[] defineClusterInternal(String name, String host, int maxCN, long maxHijack, long maxIdle) {
        HeadResourceInfo cl = new HeadResourceInfo(host, 1099);
        cl.setMaxHijackMillis(maxHijack);
        cl.setMaxIdleMillis(maxIdle);
        cl.setQueueSize(maxCN);
        cl.setName(name);
        this.clusters.add(cl);
        Object[] results = new Object[this.clusters.size()];
        for (int idx = 0; idx < results.length; ++idx) {
            results[idx] = this.clusters.get(idx).getName();
        }
        return results;
    }
}

