/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.regular.swing;

import java.util.List;
import org.gwe.api.EventListener;
import org.gwe.api.event.Event;
import org.gwe.app.client.regular.swing.JobDetails;
import org.gwe.app.client.regular.swing.RichAppModel;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.ModelSummary;

public class RichEventListener
extends EventListener {
    private final RichAppModel wizAppModel;

    public RichEventListener(RichAppModel wizAppModel) {
        this.wizAppModel = wizAppModel;
    }

    public void eventPerformed(Event ev) {
        super.eventPerformed(ev);
        List<ModelSummary> modelIds = ev.getModelIdentifiers();
        if (!JobInfo.class.isAssignableFrom(modelIds.get(0).getModelInfoClass())) {
            return;
        }
        List payloadList = (List)modelIds.get(0).getPayload();
        String jobPayload = payloadList == null || payloadList.isEmpty() ? "" : payloadList.get(0).toString();
        String jobId = modelIds.get(0).getKey().toString();
        String orderId = modelIds.get(1).getKey().toString();
        JobDetails jd = this.wizAppModel.getJobDetails(orderId, jobId);
        switch (ev.getEventType()) {
            case CREATED: {
                jd.setDetails(jobPayload);
                jd.setWaiting(true);
                break;
            }
            case JOB_ASSIGNED: {
                jd.setPreparing(true);
                break;
            }
            case JOB_DISPATCHED: {
                jd.setRunning(true);
                break;
            }
            case JOB_COMPLETED: {
                jd.setDone(true);
                jd.setResults(jobPayload);
            }
        }
        final String finalOrderId = orderId;
        new Thread(new Runnable(){

            public void run() {
                RichEventListener.this.wizAppModel.refreshJobsTable(finalOrderId);
            }
        }).start();
    }
}

