/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.client.regular.swing;

import application.Action;
import application.Application;
import application.FrameView;
import application.ResourceMap;
import application.SingleFrameApplication;
import application.TaskMonitor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import org.gwe.app.client.regular.swing.AppModel;
import org.gwe.app.client.regular.swing.ClusterDialog;
import org.gwe.app.client.regular.swing.JobDetails;
import org.gwe.app.client.regular.swing.JobDetailsDialog;
import org.gwe.app.client.regular.swing.OrderDefinitionDialog;
import org.gwe.app.client.regular.swing.RichApp;
import org.jdesktop.layout.GroupLayout;

public class RichView
extends FrameView {
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JDialog orderBox;
    private JDialog clusterBox;
    private JDialog jdBox;

    public RichView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        AppModel.getInstance().setJobsTable(this.jTable1);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                int column = target.getSelectedColumn();
                JobDetails jd = AppModel.getInstance().getJobDetails(RichView.this.jComboBox1.getSelectedItem().toString(), RichView.this.jTable1.getValueAt(row, 0).toString());
                RichView.this.viewJobDetails(jd);
            }
        });
        AppModel.getInstance().setOrdersCombo(this.jComboBox1);
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RichView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RichView.this.busyIconIndex = (RichView.this.busyIconIndex + 1) % RichView.this.busyIcons.length;
                RichView.this.statusAnimationLabel.setIcon(RichView.this.busyIcons[RichView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!RichView.this.busyIconTimer.isRunning()) {
                        RichView.this.statusAnimationLabel.setIcon(RichView.this.busyIcons[0]);
                        RichView.this.busyIconIndex = 0;
                        RichView.this.busyIconTimer.start();
                    }
                    RichView.this.progressBar.setVisible(true);
                    RichView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    RichView.this.busyIconTimer.stop();
                    RichView.this.statusAnimationLabel.setIcon(RichView.this.idleIcon);
                    RichView.this.progressBar.setVisible(false);
                    RichView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    RichView.this.statusMessageLabel.setText(text == null ? "" : text);
                    RichView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    RichView.this.progressBar.setVisible(true);
                    RichView.this.progressBar.setIndeterminate(false);
                    RichView.this.progressBar.setValue(value);
                }
            }
        });
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Job Id", "Details", "Waiting", "Preparing", "Running", "Done", "Results"}){
            Class[] types;
            {
                this.types = new Class[]{Integer.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getColumn(0).setMinWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(50);
        this.jTable1.getColumnModel().getColumn(2).setMinWidth(50);
        this.jTable1.getColumnModel().getColumn(2).setMaxWidth(50);
        this.jTable1.getColumnModel().getColumn(3).setMinWidth(60);
        this.jTable1.getColumnModel().getColumn(3).setMaxWidth(60);
        this.jTable1.getColumnModel().getColumn(4).setMinWidth(50);
        this.jTable1.getColumnModel().getColumn(4).setMaxWidth(50);
        this.jTable1.getColumnModel().getColumn(5).setMinWidth(50);
        this.jTable1.getColumnModel().getColumn(5).setMaxWidth(50);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.jComboBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RichView.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RichView.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText(Application.getInstance(RichApp.class).getContext().getResourceMap(RichView.class).getString("jLabel1.text", new Object[0]));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(1).add(mainPanelLayout.createSequentialGroup().addContainerGap().add(mainPanelLayout.createParallelGroup(1).add(2, this.jScrollPane1, -1, 618, Short.MAX_VALUE).add(mainPanelLayout.createSequentialGroup().add(this.jLabel1).add(11, 11, 11).add(this.jComboBox1, 0, 568, Short.MAX_VALUE))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(1).add(mainPanelLayout.createSequentialGroup().add(20, 20, 20).add(mainPanelLayout.createParallelGroup(3).add(this.jLabel1).add(this.jComboBox1, -2, -1, -2)).addPreferredGap(1).add(this.jScrollPane1, -1, 339, Short.MAX_VALUE).addContainerGap()));
        fileMenu.setText(Application.getInstance(RichApp.class).getContext().getResourceMap(RichView.class).getString("fileMenu.text", new Object[0]));
        this.jMenuItem1.setAction(Application.getInstance(RichApp.class).getContext().getActionMap(RichView.class, this).get("createClusterDefinition"));
        this.jMenuItem1.setText(Application.getInstance(RichApp.class).getContext().getResourceMap(RichView.class).getString("jMenuItem1.text", new Object[0]));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RichView.this.jMenuItem1ActionPerformed(evt);
            }
        });
        fileMenu.add(this.jMenuItem1);
        this.jMenuItem2.setAction(Application.getInstance(RichApp.class).getContext().getActionMap(RichView.class, this).get("submitOrder"));
        this.jMenuItem2.setText(Application.getInstance(RichApp.class).getContext().getResourceMap(RichView.class).getString("jMenuItem2.text", new Object[0]));
        fileMenu.add(this.jMenuItem2);
        exitMenuItem.setText(Application.getInstance(RichApp.class).getContext().getResourceMap(RichView.class).getString("exitMenuItem.text", new Object[0]));
        exitMenuItem.setAction(Application.getInstance(RichApp.class).getContext().getActionMap(RichView.class, this).get("quit"));
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.statusAnimationLabel.setHorizontalAlignment(2);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelSeparator, -1, 658, Short.MAX_VALUE).add(statusPanelLayout.createSequentialGroup().addContainerGap().add(this.statusMessageLabel).addPreferredGap(0, 462, Short.MAX_VALUE).add(this.progressBar, -2, -1, -2).addPreferredGap(0).add(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(statusPanelSeparator, -2, 2, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(statusPanelLayout.createParallelGroup(3).add(this.statusMessageLabel).add(this.statusAnimationLabel).add(this.progressBar, -2, -1, -2)).add(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        AppModel.getInstance().setMonitoredOrderId(evt.getItem().toString());
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
    }

    @Action
    public void createClusterDefinition() {
        JFrame mainFrame;
        if (this.clusterBox == null) {
            mainFrame = RichApp.getApplication().getMainFrame();
            this.clusterBox = new ClusterDialog((Frame)mainFrame, true);
            this.clusterBox.setLocationRelativeTo(mainFrame);
        }
        if (this.orderBox == null) {
            mainFrame = RichApp.getApplication().getMainFrame();
            this.orderBox = new OrderDefinitionDialog((Frame)mainFrame, true);
            this.orderBox.setLocationRelativeTo(mainFrame);
        }
        RichApp.getApplication().show(this.clusterBox);
    }

    @Action
    public void submitOrder() {
        if (this.orderBox == null) {
            JFrame mainFrame = RichApp.getApplication().getMainFrame();
            this.orderBox = new OrderDefinitionDialog((Frame)mainFrame, true);
            this.orderBox.setLocationRelativeTo(mainFrame);
        }
        ((OrderDefinitionDialog)this.orderBox).clearTextArea();
        RichApp.getApplication().show(this.orderBox);
    }

    @Action
    public void viewJobDetails(JobDetails jd) {
        if (this.jdBox == null) {
            JFrame mainFrame = RichApp.getApplication().getMainFrame();
            this.jdBox = new JobDetailsDialog((Frame)mainFrame, true);
            this.jdBox.setLocationRelativeTo(mainFrame);
        }
        ((JobDetailsDialog)this.jdBox).setJobDetails(jd);
        RichApp.getApplication().show(this.jdBox);
    }
}

