/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.api.DaemonAppTemplate;
import org.gwe.api.impl.ServerAPI4UserAdminImpl;
import org.gwe.app.daemon.DaemonBeacon;
import org.gwe.app.daemon.GWEDaemonAppContext;
import org.gwe.app.daemon.domain.UserAdminDomain;
import org.gwe.drivers.osAppManagers.GridOSAppManager;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.osAppManagers.MainClass;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.utils.cmd.OptionTemplate;

public class DaemonApp {
    private static Log log = LogFactory.getLog(DaemonApp.class);
    protected DaemonAppTemplate template = new DaemonAppTemplate(new OptionTemplate[0]);

    public static void main(String[] args) {
        DaemonBeacon beacon = new DaemonBeacon();
        try {
            String result = new DaemonApp().executeApp(args);
            beacon.setStop(true);
            System.out.println("\n" + result);
        }
        catch (Exception e) {
            log.fatal("Daemon application failed to launch.", e);
            System.exit(1);
        }
    }

    public String executeApp(String[] arguments) throws DaemonAppException {
        this.template.loadArgs(arguments);
        HeadResourceInfo daemonInfo = this.template.createDaemonInfoUsingArgs();
        boolean runConfigMode = this.template.isConfigMode();
        GWEDaemonAppContext.createInstance(runConfigMode, daemonInfo);
        GWEAppContext cfg = GWEDaemonAppContext.getInstance();
        JavaOSAppHandle daemonOSApp = cfg.getBeanOfClass(GridOSAppManager.class).createHandle(this.template.getGWEAppsRoot(), MainClass.DAEMON, false);
        daemonInfo.setDaemonOSApp(daemonOSApp);
        UserAdminDomain adminDomain = cfg.getBeanOfClass(UserAdminDomain.class);
        if (runConfigMode) {
            adminDomain.createDaemon(daemonInfo);
            new File(daemonInfo.getWorkspacePath()).mkdir();
        } else {
            this.verifyRegistryIsAvailable(daemonInfo.getRegistryPort());
            try {
                adminDomain.bind(cfg.getBeanOfClass(ServerAPI4UserAdminImpl.class));
            }
            catch (Exception e) {
                throw new DaemonAppException("Could not bind admin API to registry", e);
            }
        }
        return this.template.getExitToken();
    }

    private void verifyRegistryIsAvailable(int port) throws DaemonAppException {
        try {
            LocateRegistry.createRegistry(port);
            return;
        }
        catch (Exception e) {
            try {
                LocateRegistry.getRegistry(port);
                return;
            }
            catch (RemoteException remoteException) {
                throw new DaemonAppException("Could not locate/create RMI registry at port " + port);
            }
        }
    }

    class DaemonAppException
    extends Exception {
        private static final String MSG_PREFFIX = "Fatal exception while launching daemon. ";

        public DaemonAppException(String msg) {
            this(msg, null);
        }

        public DaemonAppException(String msg, Exception e) {
            super(MSG_PREFFIX + msg, e);
            log.fatal(MSG_PREFFIX + msg);
        }
    }
}

