/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon;

import org.gwe.GWEAppContext;
import org.gwe.app.daemon.domain.MonitorDomain;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.IEventLogger;

public class GWEDaemonAppContext
extends GWEAppContext {
    public static final String DEFAULT_DAEMON_CONF = "gwe-daemon.xml";
    private static final String PROP_DAEMON_LOCATION = "daemon.location";
    private static final String PROP_DAEMON_HOME = "daemon.home";
    private static final String PROP_DB_INSTALL = "db.install";
    private IEventLogger monitorDomain;

    public static void createInstance(boolean runConfigMode, HeadResourceInfo daemonInfo) {
        System.setProperty(PROP_DB_INSTALL, String.valueOf(runConfigMode));
        System.setProperty(PROP_DAEMON_HOME, System.getProperty("user.dir"));
        System.setProperty(PROP_DAEMON_LOCATION, daemonInfo.getLocation());
        GWEDaemonAppContext.setInstance(new GWEDaemonAppContext("", daemonInfo.getHost()));
    }

    protected GWEDaemonAppContext(String appWorkspace, String localHostName) {
        super(appWorkspace, DEFAULT_DAEMON_CONF);
        this.gridFileSystem.setLocalHostName(localHostName);
        this.monitorDomain = this.getBeanOfClass(MonitorDomain.class);
    }

    public IEventLogger getEventLogger() {
        return this.monitorDomain;
    }
}

