/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.ShutdownDaemonRequest;
import org.gwe.app.daemon.domain.AllocationNotFoundException;
import org.gwe.app.daemon.domain.BaseDomain;
import org.gwe.app.daemon.domain.LiveAllocations;
import org.gwe.app.daemon.domain.LiveJobs;
import org.gwe.app.daemon.domain.LiveOrders;
import org.gwe.app.daemon.domain.NoJobToProcessException;
import org.gwe.persistence.model.AllocationInfo;
import org.gwe.persistence.model.ComputeResourceInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.order.DaemonRequest;
import org.gwe.utils.concurrent.BooleanLock;
import org.gwe.utils.concurrent.ThreadPoolUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentDomain
extends BaseDomain {
    private static Log log = LogFactory.getLog(AgentDomain.class);
    public static final int JOB_PREPARATION_OVER_ALLOCATIONS_FACTOR = 2;
    private ExecutorService allocKillersThreadPool = ThreadPoolUtils.createThreadPool("Allocation Killers");
    private ExecutorService jobFinalizersThreadPool = ThreadPoolUtils.createThreadPool("Jobs Finalizers");
    private LiveOrders liveOrders = new LiveOrders();
    private LiveJobs liveJobs = new LiveJobs();
    private LiveAllocations liveAllocs = new LiveAllocations();
    private Map<Integer, Integer> ordersWithCompletedJobs = new HashMap<Integer, Integer>();
    private BooleanLock preparerLock = new BooleanLock();

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean createAllocation(int allocId, ComputeResourceInfo compRes) throws AllocationNotFoundException {
        AllocationInfo alloc = this.liveAllocs.getBusyAllocation(allocId);
        if (alloc.isRegistered()) {
            return false;
        }
        if (compRes != null) {
            alloc.setCompResource(compRes);
            this.allocKillersThreadPool.submit(alloc.getDeathDealer());
        }
        this.allocationDAO.update(alloc);
        return true;
    }

    public DaemonRequest<?> extractRequestFromNextJobAssignedBlocking(int allocId) throws AllocationNotFoundException, NoJobToProcessException {
        AllocationInfo alloc = this.liveAllocs.getBusyAllocation(allocId);
        this.liveAllocs.flagAsReady(alloc);
        JobInfo jobToProcess = alloc.getNextProcessingJobBlocking();
        if (jobToProcess == null) {
            throw new NoJobToProcessException();
        }
        jobToProcess.flagAsDispatched();
        return jobToProcess.getRequest();
    }

    public void cleanAllocAndFinalizeJobAsync(int allocId, final Serializable result) throws AllocationNotFoundException {
        AllocationInfo alloc = this.liveAllocs.getBusyAllocation(allocId);
        final JobInfo jobProcessed = alloc.extractProcessingJob();
        if (jobProcessed == null) {
            log.warn("Job processed lost from allocation " + alloc.getId() + " with results:\n" + result);
            return;
        }
        this.jobFinalizersThreadPool.submit(new Runnable(){

            public void run() {
                jobProcessed.postProcessInDaemonInternal(AgentDomain.this.liveOrders.getStartedOrder(jobProcessed.getOrderId()), result);
                AgentDomain.this.wrapUpJob(jobProcessed);
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void wrapUpJob(JobInfo jobProcessed) {
        try {
            this.jobDAO.update(jobProcessed);
        }
        catch (Exception e) {
            log.error("Problems encountered while trying to update job & order for jobId:" + jobProcessed.getId(), e);
        }
        this.incrementJobsFinished(jobProcessed.getOrderId(), jobProcessed.getComputeTime());
    }

    public ShutdownDaemonRequest disposeLiveAllocation(int allocId, Exception ex) {
        AllocationInfo alloc;
        if (ex != null && !(ex instanceof NoJobToProcessException)) {
            log.error("Error encountered while executing a domain services. Disposing allocation " + allocId, ex);
        }
        if ((alloc = this.liveAllocs.removeAllocation(allocId)) != null) {
            JobInfo orphanJob = alloc.dispose(ex == null);
            this.liveJobs.addPreparedJob(orphanJob);
            this.allocationDAO.update(alloc);
            this.triggerMoreJobsAndAllocationPreparation();
            return new ShutdownDaemonRequest(alloc.getReleaseReason(), ex);
        }
        return new ShutdownDaemonRequest(-1, ex);
    }

    public void triggerMoreJobsAndAllocationPreparation() {
        this.preparerLock.releaseLock();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<AllocationInfo> prepareMoreJobsAndAllocations() {
        this.preparerLock.waitUntilReleased();
        HeadResourceInfo daemonInfo = this.headResourceDAO.getDaemonInfo();
        int pending = this.jobDAO.getPendingJobsCount() + this.liveJobs.size();
        int queueSize = daemonInfo.getQueueSize();
        int amount = pending;
        if (queueSize > 0) {
            int unusedQueueSize = queueSize - this.liveAllocs.getLiveAllocationsCount();
            if (pending > unusedQueueSize) {
                amount = unusedQueueSize;
            }
        } else {
            amount -= this.liveAllocs.getLiveAllocationsCount();
        }
        return this.prepareAllocations(daemonInfo, amount);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<AllocationInfo> prepareAllocations(HeadResourceInfo daemonInfo, int amount) {
        ArrayList<AllocationInfo> allocations = new ArrayList<AllocationInfo>();
        if (amount > 0) {
            for (int count = 0; count < amount; ++count) {
                allocations.add(new AllocationInfo(daemonInfo));
            }
            this.allocationDAO.saveAll(allocations);
            this.liveAllocs.saveLiveAllocations(allocations);
        }
        return allocations;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInfo> startJobs() {
        List<JobInfo> jobs = new ArrayList<JobInfo>();
        int amount = this.liveAllocs.getLiveAllocationsCount() * 2 - this.liveJobs.size();
        if (amount > 0) {
            jobs = this.jobDAO.getNextSchedulableJobsBatch(amount);
            if (jobs != null && !jobs.isEmpty()) {
                log.info("Preparing jobs: " + jobs);
                for (JobInfo job : jobs) {
                    job.flagAsStarted();
                }
            }
            this.jobDAO.saveOrUpdateAll(jobs);
        }
        this.loadOrders(jobs);
        return jobs;
    }

    private void loadOrders(List<JobInfo> jobs) {
        Set<Integer> orderIds = this.liveOrders.getJobsOrdersNotStarted(jobs);
        if (orderIds.isEmpty()) {
            return;
        }
        List<OrderInfo> orders = this.orderDAO.getByIds("id", orderIds);
        this.liveOrders.startOrders(orders, this.headResourceDAO.getDaemonInfo());
        for (OrderInfo order : orders) {
            this.orderDAO.evict(order);
        }
    }

    public void prepareJobs(List<JobInfo> jobs) {
        for (JobInfo job : jobs) {
            job.setRunningDaemon(this.headResourceDAO.getDaemonInfo());
            job.setOrderWorkspace(this.liveOrders.getStartedOrder(job.getOrderId()).getWorkspacePathInCluster());
        }
        this.liveJobs.prepareJobs(this.liveOrders.getJobsRuntimeControllers(jobs));
    }

    public void flagNextPreparedJobAsReady() throws InterruptedException, ExecutionException {
        JobInfo nextJob = this.liveJobs.flagNextPreparedJobAsReady();
        if (nextJob.hasFailed()) {
            this.wrapUpJob(nextJob);
        }
        this.triggerMoreJobsAndAllocationPreparation();
    }

    public void pairNextJobAndAllocationReady() throws Exception {
        this.triggerMoreJobsAndAllocationPreparation();
        this.liveAllocs.pairNextReadyAllocationWithJob(this.liveJobs.getNextReadyJob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementJobsFinished(int orderId, long computeTime) {
        Map<Integer, Integer> map = this.ordersWithCompletedJobs;
        synchronized (map) {
            Integer currentCount = this.ordersWithCompletedJobs.get(orderId);
            if (currentCount == null) {
                currentCount = 0;
            }
            this.ordersWithCompletedJobs.put(orderId, currentCount + 1);
            this.ordersWithCompletedJobs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUpdateOrdersCycle() {
        int nextOrderId = -1;
        int nextAmount = -1;
        Map<Integer, Integer> map = this.ordersWithCompletedJobs;
        synchronized (map) {
            while (this.ordersWithCompletedJobs.isEmpty()) {
                try {
                    this.ordersWithCompletedJobs.wait();
                }
                catch (InterruptedException e) {}
            }
            nextOrderId = this.ordersWithCompletedJobs.keySet().iterator().next();
            nextAmount = this.ordersWithCompletedJobs.get(nextOrderId);
            this.ordersWithCompletedJobs.remove(nextOrderId);
        }
        this.updateOrder(nextOrderId, nextAmount);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateOrder(int orderId, int amount) {
        OrderInfo order = (OrderInfo)this.orderDAO.get(orderId);
        order.incrementJobsFinished(amount);
        if (order.isFinished()) {
            this.liveOrders.endOrder(order.getId());
        }
        this.orderDAO.update(order);
    }
}

