/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwe.app.daemon.domain.AllocationNotFoundException;
import org.gwe.persistence.model.AllocationInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.utils.concurrent.BlockingMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveAllocations {
    private Map<Integer, AllocationInfo> busyAllocations = new HashMap<Integer, AllocationInfo>();
    private BlockingMap<Integer, AllocationInfo> readyAllocations = new BlockingMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLiveAllocations(List<AllocationInfo> allocList) {
        BlockingMap<Integer, AllocationInfo> blockingMap = this.readyAllocations;
        synchronized (blockingMap) {
            for (AllocationInfo alloc : allocList) {
                this.busyAllocations.put(alloc.getId(), alloc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLiveAllocation(AllocationInfo alloc) {
        BlockingMap<Integer, AllocationInfo> blockingMap = this.readyAllocations;
        synchronized (blockingMap) {
            this.busyAllocations.put(alloc.getId(), alloc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocationInfo getBusyAllocation(int allocId) throws AllocationNotFoundException {
        BlockingMap<Integer, AllocationInfo> blockingMap = this.readyAllocations;
        synchronized (blockingMap) {
            AllocationInfo alloc = this.busyAllocations.get(allocId);
            if (alloc == null) {
                throw new AllocationNotFoundException(allocId);
            }
            return alloc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocationInfo removeAllocation(int allocId) {
        BlockingMap<Integer, AllocationInfo> blockingMap = this.readyAllocations;
        synchronized (blockingMap) {
            AllocationInfo busyAlloc = this.busyAllocations.remove(allocId);
            return busyAlloc != null ? busyAlloc : this.readyAllocations.remove(allocId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLiveAllocationsCount() {
        BlockingMap<Integer, AllocationInfo> blockingMap = this.readyAllocations;
        synchronized (blockingMap) {
            return this.busyAllocations.size() + this.readyAllocations.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flagAsReady(AllocationInfo alloc) {
        BlockingMap<Integer, AllocationInfo> blockingMap = this.readyAllocations;
        synchronized (blockingMap) {
            Integer allocId = alloc.getId();
            this.readyAllocations.put(allocId, this.busyAllocations.remove(allocId));
            alloc.startIdleCountdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pairNextReadyAllocationWithJob(JobInfo job) {
        BlockingMap<Integer, AllocationInfo> blockingMap = this.readyAllocations;
        synchronized (blockingMap) {
            AllocationInfo alloc;
            do {
                alloc = this.readyAllocations.takeOne();
                assert (alloc != null);
            } while (!alloc.setProcessingJob(job));
            this.busyAllocations.put(alloc.getId(), alloc);
        }
    }
}

