/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.order.OrderRuntimeController;
import org.gwe.utils.concurrent.BlockingList;
import org.gwe.utils.concurrent.ThreadPoolUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveJobs {
    private CompletionService<JobInfo> jobPreparersThreadPool = new ExecutorCompletionService<JobInfo>(ThreadPoolUtils.createThreadPool("Jobs Preparers"));
    private BlockingList<JobInfo> preparedJobs = new BlockingList();
    private List<JobInfo> preparingJobs = new ArrayList<JobInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareJobs(Map<JobInfo, OrderRuntimeController> jobs) {
        BlockingList<JobInfo> blockingList = this.preparedJobs;
        synchronized (blockingList) {
            this.preparingJobs.addAll(jobs.keySet());
        }
        for (JobInfo job : jobs.keySet()) {
            Runnable preparer = job.createPreparingRunnable(jobs.get(job));
            this.jobPreparersThreadPool.submit(preparer, job);
        }
    }

    public JobInfo getNextReadyJob() {
        return this.preparedJobs.takeOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        BlockingList<JobInfo> blockingList = this.preparedJobs;
        synchronized (blockingList) {
            return this.preparingJobs.size() + this.preparedJobs.size();
        }
    }

    public JobInfo flagNextPreparedJobAsReady() throws InterruptedException, ExecutionException {
        return this.schedulePreparedJob(this.jobPreparersThreadPool.take().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobInfo schedulePreparedJob(JobInfo job) {
        BlockingList<JobInfo> blockingList = this.preparedJobs;
        synchronized (blockingList) {
            this.preparingJobs.remove(job);
            if (!job.hasFailed()) {
                this.addPreparedJob(job);
            }
            return job;
        }
    }

    public void addPreparedJob(JobInfo job) {
        if (job != null) {
            this.preparedJobs.add(job);
        }
    }
}

