/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.order.OrderRuntimeController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveOrders {
    private Map<Integer, OrderRuntimeController> orderRCs = new HashMap<Integer, OrderRuntimeController>();

    public synchronized void startOrders(List<OrderInfo> newOrders, HeadResourceInfo daemonInfo) {
        for (OrderInfo order : newOrders) {
            this.orderRCs.put(order.getId(), new OrderRuntimeController(order, daemonInfo));
        }
    }

    public synchronized OrderRuntimeController getStartedOrder(int orderId) {
        return this.orderRCs.get(orderId);
    }

    public synchronized void endOrder(int orderId) {
        OrderRuntimeController orderRC = this.orderRCs.remove(orderId);
        if (orderRC != null) {
            orderRC.wrapUp();
        }
    }

    public synchronized Set<Integer> getJobsOrdersNotStarted(List<JobInfo> jobs) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (JobInfo job : jobs) {
            int orderId = job.getOrderId();
            if (this.orderRCs.containsKey(orderId)) continue;
            result.add(orderId);
        }
        return result;
    }

    public synchronized Map<JobInfo, OrderRuntimeController> getJobsRuntimeControllers(List<JobInfo> jobs) {
        HashMap<JobInfo, OrderRuntimeController> result = new HashMap<JobInfo, OrderRuntimeController>();
        for (JobInfo job : jobs) {
            result.put(job, this.orderRCs.get(job.getOrderId()));
        }
        return result;
    }
}

