/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwe.api.event.Event;
import org.gwe.api.event.EventFilter;
import org.gwe.app.daemon.domain.BaseDomain;
import org.gwe.persistence.model.BaseModelInfo;
import org.gwe.persistence.model.EventType;
import org.gwe.persistence.model.IEventLogger;
import org.gwe.utils.concurrent.BlockingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorDomain
extends BaseDomain
implements Runnable,
IEventLogger {
    private Map<Long, UserEventNotifier> notifiers = new HashMap<Long, UserEventNotifier>();
    private BlockingList<Event> events = new BlockingList();

    @Override
    public <KEY_TYPE> Timestamp logEvent(BaseModelInfo<KEY_TYPE> source, EventType evType) {
        return this.logEvent(source, evType, new Timestamp(System.currentTimeMillis()), new BaseModelInfo[0]);
    }

    @Override
    public <KEY_TYPE> Timestamp logEvent(BaseModelInfo<KEY_TYPE> source, EventType evType, Timestamp when, BaseModelInfo ... relatedModels) {
        this.events.add(new Event(evType, source, relatedModels));
        return when;
    }

    public long createHandle() {
        return System.currentTimeMillis();
    }

    public List<Event> getNextEvents(long handle, EventFilter filter) {
        return this.getUserEventNotifier(handle).getNextEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserEventNotifier getUserEventNotifier(long handle) {
        Map<Long, UserEventNotifier> map = this.notifiers;
        synchronized (map) {
            UserEventNotifier notif = this.notifiers.get(handle);
            if (notif == null) {
                notif = new UserEventNotifier(handle);
                this.notifiers.put(handle, notif);
            }
            return notif;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeNotifier(long handle) {
        Map<Long, UserEventNotifier> map = this.notifiers;
        synchronized (map) {
            this.notifiers.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block3: while (true) {
            if ((eventsCopy = this.events.takeAll()).isEmpty()) {
                continue;
            }
            var3_3 = this.notifiers;
            synchronized (var3_3) {
                notifiersCopy = this.notifiers.values();
            }
            i$ = notifiersCopy.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block3;
                notif = i$.next();
                UserEventNotifier.access$200(notif, eventsCopy);
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UserEventNotifier {
        private Long monitoringHandle;
        private List<Event> userEvents = new ArrayList<Event>();

        private UserEventNotifier(long monitoringHandle) {
            this.monitoringHandle = monitoringHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Event> getNextEvents() {
            ArrayList<Event> result = new ArrayList<Event>();
            Long l = this.monitoringHandle;
            synchronized (l) {
                while (this.userEvents.isEmpty()) {
                    try {
                        this.monitoringHandle.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                result.addAll(this.userEvents);
                this.userEvents.clear();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postEvents(List<Event> events) {
            Long l = this.monitoringHandle;
            synchronized (l) {
                this.userEvents.addAll(events);
                this.monitoringHandle.notify();
            }
        }

        static /* synthetic */ void access$200(UserEventNotifier x0, List x1) {
            x0.postEvents(x1);
        }
    }
}

