/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwe.app.daemon.domain.OrderStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulingCalculator {
    private List<OrderStats> queueStats;
    private int totalAmount;
    private long now = System.currentTimeMillis();

    public SchedulingCalculator(List<OrderStats> queueStats, int totalAmount) {
        this.queueStats = queueStats;
        this.totalAmount = totalAmount;
    }

    public Map<String, Integer> computeSchedulingStrategy() {
        for (int count = 0; count < this.totalAmount; ++count) {
            this.pickSchedulingCandidate().increaseSchedulingAmount();
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (OrderStats stats : this.queueStats) {
            if (stats.getSchedulingAmount() == 0) continue;
            result.put(stats.getUserId(), stats.getSchedulingAmount());
        }
        return result;
    }

    private OrderStats pickSchedulingCandidate() {
        int totalWaitFeeUnits = 0;
        long totalAvgWaitTime = 0L;
        for (OrderStats stats : this.queueStats) {
            stats.setNow(this.now);
            totalWaitFeeUnits += stats.getWaitFeeLevel();
            totalAvgWaitTime += stats.getWaitTime();
        }
        float waitPerWeightUnit = totalAvgWaitTime / (long)totalWaitFeeUnits;
        OrderStats candidate = null;
        float candidateDebt = 0.0f;
        for (OrderStats stats : this.queueStats) {
            float debtTime;
            if (candidate != null || !((debtTime = stats.getDebtTime(waitPerWeightUnit)) < candidateDebt)) continue;
            candidate = stats;
            candidateDebt = debtTime;
        }
        return candidate;
    }
}

