/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.io.FileOutputStream;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.exceptions.DaemonNotFoundException;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.api.exceptions.ServerAPIsBindingException;
import org.gwe.api.exceptions.UserIsNotDaemonAdminException;
import org.gwe.api.exceptions.UserNotSpecifiedException;
import org.gwe.api.impl.BaseServerAPIImpl;
import org.gwe.app.daemon.domain.UserDomain;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.IOUtils;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAdminDomain
extends UserDomain {
    private static Log log = LogFactory.getLog(UserAdminDomain.class);
    private static final Set hackToPreventGarbageCollection = new HashSet();
    private Set<BaseServerAPIImpl> serverAPIs;
    private Map<Runnable, String> daemonThreadServices;
    private Boolean started = new Boolean(false);

    public static void startBackgroundService(Runnable serv, String name) {
        Thread threadObj = new Thread(serv, "BG Service: " + name);
        threadObj.setDaemon(true);
        threadObj.start();
    }

    public void setServerAPIs(Set<BaseServerAPIImpl> serverAPIs) {
        this.serverAPIs = serverAPIs;
    }

    public void setDaemonThreadServices(Map<Runnable, String> daemonThreadServices) {
        this.daemonThreadServices = daemonThreadServices;
    }

    public void verifyIsDaemonUserAdmin(UserInfo applyingUser) throws PasswordMismatchException, UserNotSpecifiedException, UserIsNotDaemonAdminException {
        HeadResourceInfo daemonInfo = this.headResourceDAO.getDaemonInfo();
        UserInfo admin = daemonInfo.getAdmin();
        if (admin == null) {
            this.getOrCreateUser(applyingUser);
            return;
        }
        if (!admin.getId().equals(applyingUser.getId())) {
            throw new UserIsNotDaemonAdminException(applyingUser);
        }
        if (!admin.isDaemonUserAdmin(applyingUser, daemonInfo)) {
            throw new PasswordMismatchException(applyingUser.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDaemon(UserInfo admin) throws ServerAPIsBindingException {
        Boolean bl = this.started;
        synchronized (bl) {
            if (this.started.booleanValue()) {
                return;
            }
            try {
                for (BaseServerAPIImpl api : this.serverAPIs) {
                    hackToPreventGarbageCollection.add(this.bind(api));
                }
            }
            catch (Exception e) {
                String msg = "Could not bind daemon APIs to registry";
                log.fatal(msg, e);
                throw new ServerAPIsBindingException(msg);
            }
            for (Runnable serv : this.daemonThreadServices.keySet()) {
                UserAdminDomain.startBackgroundService(serv, this.daemonThreadServices.get(serv));
            }
            this.started = true;
        }
    }

    public void createDaemon(HeadResourceInfo daemonInfo) {
        this.headResourceDAO.save(daemonInfo);
    }

    public HeadResourceInfo getPersistedDaemon(UserInfo user, String daemonLocation) throws DaemonNotFoundException, UserIsNotDaemonAdminException {
        HeadResourceInfo persistedDaemon = (HeadResourceInfo)this.headResourceDAO.get(daemonLocation);
        if (persistedDaemon == null) {
            throw new DaemonNotFoundException(daemonLocation);
        }
        if (!user.equals(persistedDaemon.getAdmin())) {
            throw new UserIsNotDaemonAdminException(user);
        }
        return persistedDaemon;
    }

    public <API_TYPE extends Remote> API_TYPE bind(BaseServerAPIImpl<API_TYPE, ?> api) throws Exception {
        return api.bind(this.headResourceDAO.getDaemonInfo().getLocation());
    }

    public void updateAgentsAuthInfo(UserInfo admin) throws Exception {
        HeadResourceInfo daemonInfo = this.headResourceDAO.getDaemonInfo();
        URILink link = admin.getKeyStore().generateURILink(daemonInfo.getCompURI());
        FileOutputStream fos = new FileOutputStream(daemonInfo.getLinkSerializedFilePath());
        fos.write(IOUtils.serializeObject(link));
        fos.close();
    }

    public void configureDaemon(UserInfo admin, HeadResourceInfo daemonInfo) {
    }

    public void shutdownDaemon(UserInfo admin) {
    }
}

