/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gwe.api.exceptions.PasswordMismatchException;
import org.gwe.api.exceptions.UserNotSpecifiedException;
import org.gwe.app.daemon.domain.BaseDomain;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.UserInfo;

public class UserDomain
extends BaseDomain {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(\\w+)@(\\w+\\.)(\\w+)(\\.\\w+)*");

    public UserInfo getOrCreateUser(UserInfo user) throws PasswordMismatchException, UserNotSpecifiedException {
        return this.getPersistedUser(user, true);
    }

    public UserInfo getPersistedUser(UserInfo applyingUser, boolean createIfNonExistent) throws PasswordMismatchException, UserNotSpecifiedException {
        if (applyingUser == null || applyingUser.getName() == null) {
            throw new UserNotSpecifiedException();
        }
        UserInfo persistedUser = (UserInfo)this.userDAO.get(applyingUser.getName());
        if (persistedUser == null) {
            if (!createIfNonExistent) {
                return null;
            }
            persistedUser = new UserInfo(applyingUser, this.headResourceDAO.getDaemonInfo());
            this.userDAO.save(persistedUser);
            this.defineGrid(persistedUser, this.headResourceDAO.getDaemonLocation(), new String[]{this.headResourceDAO.getDaemonLocation()});
        }
        if (!persistedUser.matchesPassword(applyingUser)) {
            throw new PasswordMismatchException(applyingUser.getName());
        }
        return persistedUser;
    }

    private boolean isEmail(String target) {
        Matcher matcher = EMAIL_PATTERN.matcher(target);
        if (!matcher.find()) {
            return false;
        }
        return !matcher.find();
    }

    public GridInfo defineGrid(UserInfo user, String name, String[] headLocations) {
        GridInfo grid = new GridInfo(name, user, this.headResourceDAO.getByLocations(headLocations));
        this.gridDAO.save(grid);
        return grid;
    }
}

