/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain;

import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.api.exceptions.GridNotFoundException;
import org.gwe.api.exceptions.GridNotSpecifiedException;
import org.gwe.api.exceptions.OrderNotOwnedException;
import org.gwe.api.exceptions.OrderNotSpecifiedException;
import org.gwe.app.daemon.domain.UserDomain;
import org.gwe.persistence.model.GridInfo;
import org.gwe.persistence.model.HeadResourceInfo;
import org.gwe.persistence.model.JobInfo;
import org.gwe.persistence.model.OrderInfo;
import org.gwe.persistence.model.UserInfo;
import org.gwe.utils.concurrent.BlockingList;
import org.gwe.utils.security.KeyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserRegularDomain
extends UserDomain {
    private static Log log = LogFactory.getLog(UserRegularDomain.class);
    private BlockingList<OrderInfo> newOrders = new BlockingList();

    public void setUserKeyStore(UserInfo user, KeyStore keys) {
        user.setKeyStore(keys);
        this.userDAO.update(user);
    }

    public GridInfo getGrid(UserInfo user, String gridName) {
        return (GridInfo)this.gridDAO.get(GridInfo.generateId(user, gridName));
    }

    public Set<GridInfo> getGridsDefined(UserInfo user) {
        return user.getGrids();
    }

    public List<OrderInfo> getOrdersDefined(UserInfo user) {
        List<OrderInfo> orders = user.getOrders();
        orders.size();
        return orders;
    }

    public List<OrderInfo> getOrdersList(UserInfo user, boolean includeJobs) {
        List<OrderInfo> result = this.getOrdersDefined(user);
        if (includeJobs) {
            for (OrderInfo order : result) {
                order.getJobs().size();
            }
        }
        return result;
    }

    public OrderInfo getOrderDetails(UserInfo user, String userOrderId, boolean includeJobs) throws OrderNotOwnedException {
        OrderInfo order = this.orderDAO.getByOrderUserId(userOrderId);
        this.verifyOrderBelongsToUser(user, order);
        if (includeJobs) {
            order.getJobs().size();
        }
        return order;
    }

    public List<OrderInfo> getOrdersByDescription(UserInfo user, String description) {
        return this.orderDAO.getByDescription(user.getId(), description);
    }

    public JobInfo getJobDetails(UserInfo user, int orderId, int jobNum) throws OrderNotOwnedException {
        this.getOrder(user, orderId, false);
        return (JobInfo)this.jobDAO.get(JobInfo.generateId(orderId, jobNum));
    }

    public OrderInfo getOrder(UserInfo user, int orderId, boolean includeJobs) throws OrderNotOwnedException {
        OrderInfo order = this.orderDAO.getOrder(orderId, includeJobs);
        this.verifyOrderBelongsToUser(user, order);
        return order;
    }

    private void verifyOrderBelongsToUser(UserInfo user, OrderInfo order) throws OrderNotOwnedException {
        if (order != null && !order.getOwner().getId().equals(user.getId())) {
            throw new OrderNotOwnedException(user, order);
        }
    }

    public OrderInfo persistOrder(UserInfo user, OrderInfo order) throws OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException {
        String defaultGrid = GridInfo.generateId(user, this.headResourceDAO.getDaemonLocation());
        return this.persistOrder(user, defaultGrid, order);
    }

    public OrderInfo persistOrder(UserInfo user, String gridId, OrderInfo order) throws OrderNotSpecifiedException, GridNotSpecifiedException, GridNotFoundException {
        if (order == null) {
            throw new OrderNotSpecifiedException();
        }
        if (gridId == null || gridId.equals("")) {
            throw new GridNotSpecifiedException();
        }
        GridInfo grid = user.getDefinedGrid(gridId);
        if (grid == null) {
            throw new GridNotFoundException();
        }
        user.associateOrder(order, grid);
        this.orderDAO.save(order);
        return order;
    }

    public void queueOrder(OrderInfo order) {
        this.newOrders.add(order);
    }

    public void pauseOrder(UserInfo user, int orderId, boolean pause) throws OrderNotOwnedException {
        this.getOrder(user, orderId, false).setPaused(true);
    }

    public void abortOrder(UserInfo user, int orderId) throws OrderNotOwnedException {
        this.getOrder(user, orderId, false).setAborted(true);
    }

    public void deleteOrder(UserInfo user, int orderId) throws OrderNotOwnedException {
        OrderInfo order = this.getOrder(user, orderId, false);
        this.jobDAO.deleteAll(order.getJobs());
        this.orderDAO.delete(order);
    }

    public List<OrderInfo> processQueuedOrders() {
        List<OrderInfo> newOrdersCopy = this.newOrders.takeAll();
        HeadResourceInfo daemonInfo = this.headResourceDAO.getDaemonInfo();
        for (OrderInfo order : newOrdersCopy) {
            List<JobInfo> generateJobs = order.generateJobs(daemonInfo);
            this.jobDAO.saveAll(generateJobs);
        }
        this.orderDAO.saveOrUpdateAll(newOrdersCopy);
        return newOrdersCopy;
    }
}

