/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.app.daemon.domain.background;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.app.daemon.domain.AgentDomain;
import org.gwe.app.daemon.domain.background.AgentDomainBasedService;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.resManagers.GridResourceManager;
import org.gwe.drivers.resManagers.ResourceManagerHandle;
import org.gwe.persistence.model.AllocationInfo;
import org.gwe.utils.concurrent.ThreadPoolUtils;

public class JobsAndAllocationsPreparer
extends AgentDomainBasedService {
    private static Log log = LogFactory.getLog(JobsAndAllocationsPreparer.class);
    private ExecutorService allocCreatorsThreadPool = ThreadPoolUtils.createThreadPool("Allocation Schedulers");
    private GridResourceManager gridResourceManager = null;
    private ResourceManagerHandle resourceManagerHandle = null;

    public JobsAndAllocationsPreparer(AgentDomain agentDom, GridResourceManager gridResourceManager) {
        super("Jobs & Allocations Preparer", agentDom);
        this.gridResourceManager = gridResourceManager;
    }

    private void createResourceManagerHandle() {
        if (this.resourceManagerHandle != null) {
            return;
        }
        try {
            this.resourceManagerHandle = (ResourceManagerHandle)this.gridResourceManager.createHandle();
        }
        catch (HandleOperationException e) {
            log.fatal("Could not create resource manager handle to allocate compute nodes", e);
            System.exit(1);
        }
    }

    public void execute() throws Exception {
        this.createResourceManagerHandle();
        List<AllocationInfo> allocations = this.agentDom.prepareMoreJobsAndAllocations();
        this.agentDom.prepareJobs(this.agentDom.startJobs());
        log.info("Allocating compute resources: " + allocations);
        Iterator<AllocationInfo> i$ = allocations.iterator();
        while (i$.hasNext()) {
            AllocationInfo alloc;
            final AllocationInfo currAlloc = alloc = i$.next();
            this.allocCreatorsThreadPool.submit(new Runnable(){

                public void run() {
                    try {
                        JobsAndAllocationsPreparer.this.resourceManagerHandle.allocateComputeResource(currAlloc);
                    }
                    catch (Exception e) {
                        log.debug("Exception thrown while trying to allocate a compute resource.", e);
                    }
                }
            });
        }
    }
}

