/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.Driver;
import org.gwe.drivers.HandleCreationException;
import org.gwe.drivers.HandleCreationNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriversManager<DRIVER_TYPE extends Driver<HANDLE_TYPE, HANDLE_PARAM_TYPE>, HANDLE_TYPE, HANDLE_PARAM_TYPE> {
    private static Log log = LogFactory.getLog(DriversManager.class);
    protected List<DRIVER_TYPE> drivers;
    private String localHostName = "localhost";

    public DriversManager(List<DRIVER_TYPE> drivers) {
        if (drivers == null) {
            return;
        }
        this.drivers = new ArrayList<DRIVER_TYPE>(drivers.size());
        this.drivers.addAll(drivers);
        try {
            this.localHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void setDrivers(List<DRIVER_TYPE> drivers) {
        this.drivers = drivers;
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    public void setLocalHostName(String localHost) {
        this.localHostName = localHost;
    }

    public HANDLE_TYPE createHandle() throws HandleCreationException {
        return this.createHandle(null);
    }

    public HANDLE_TYPE createHandle(HANDLE_PARAM_TYPE handleParams) throws HandleCreationException {
        for (Driver driver : this.drivers) {
            try {
                return driver.tryToCreateHandle(handleParams);
            }
            catch (HandleCreationNotSupportedException e) {
            }
            catch (Exception e) {
                String msg = "Problem encountered while trying to create handle with params " + handleParams + " using driver '" + this.getClass().getName() + "'. Exception: " + e.getMessage();
                log.warn(msg, e.getCause());
            }
        }
        throw new HandleCreationException("There was no driver able to create a handle for '" + handleParams + "'");
    }
}

