/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.bundleManagers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.drivers.bundleManagers.BundleType;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.URILink;

public class BundleHandle {
    private static Log log = LogFactory.getLog(BundleHandle.class);
    protected BundleType type;
    protected String path;
    protected String name;

    BundleHandle(BundleType type, String path, String name) {
        this.setType(type);
        this.setPath(path);
        this.setName(name + "." + type.getExtension());
    }

    public BundleType getType() {
        return this.type;
    }

    public void setType(BundleType type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullPath() {
        return this.getPath() + "/" + this.getName();
    }

    public String getUnbundleCommand() {
        return this.type.getUnbundleCommand() + " " + this.getName();
    }

    public boolean deploy(URILink destLink, String unbundleCmdPath, String deploymentRoot, KeyStore keys) throws Exception {
        String deploymentDir = destLink.createFSURI(deploymentRoot);
        if (GWEAppContext.getGridFileSystem().createHandle(deploymentDir, keys).isDirectory()) {
            log.info("Cannot deploy '" + this.getFullPath() + "' because directory target '" + unbundleCmdPath + "' already exists. This bundle may have been already deployed there.");
            return false;
        }
        String destFile = destLink.createFSURI(unbundleCmdPath + "/" + this.getName());
        GWEAppContext.getGridFileSystem().transferFile(this.getFullPath(), destFile, keys);
        NetworkAccessHandle conn = GWEAppContext.getGridNetworkAccess().createHandle(destLink, keys);
        String result = conn.runCommand(this.getUnbundleCommand(), unbundleCmdPath, null);
        log.info("'" + this.getFullPath() + "' deployment results:\n" + result);
        GWEAppContext.getGridFileSystem().createHandle(destFile, keys).delete();
        return true;
    }
}

