/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.HandleOperationException;
import org.gwe.utils.IOUtils;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileHandle {
    private static Log log = LogFactory.getLog(FileHandle.class);
    protected URILink link;

    public FileHandle(URILink link) {
        this.link = link;
    }

    public URI getURI() {
        return this.link.getURI();
    }

    public URILink getLink() {
        return this.link;
    }

    public abstract boolean isDirectory() throws HandleOperationException;

    public abstract InputStream getInputStream() throws HandleOperationException;

    public abstract OutputStream getOutputStream() throws HandleOperationException;

    public abstract void create() throws HandleOperationException;

    public abstract boolean exists() throws HandleOperationException;

    public boolean delete() throws HandleOperationException {
        throw new HandleOperationException("Operation Not Supported!");
    }

    public void close() throws HandleOperationException {
    }

    public boolean isGlob() {
        return this.link.getURI().toString().matches(".*[\\*\\?\\[].*");
    }

    public <OBJECT_TYPE> OBJECT_TYPE readObject() throws HandleOperationException {
        try {
            ObjectInputStream ois = new ObjectInputStream(this.getInputStream());
            Object result = ois.readObject();
            ois.close();
            return (OBJECT_TYPE)result;
        }
        catch (IOException e) {
            throw new HandleOperationException("Could not read object from file", e);
        }
        catch (ClassNotFoundException e) {
            throw new HandleOperationException("Could not read object from file", e);
        }
    }

    public void storeObject(Object toSerialize) throws HandleOperationException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(this.getOutputStream());
            oos.writeObject(toSerialize);
            oos.close();
        }
        catch (IOException e) {
            throw new HandleOperationException(e);
        }
    }

    public void copy(boolean outgoing, FileHandle otherFile) throws HandleOperationException {
        FileHandle srcFile;
        FileHandle fileHandle = srcFile = outgoing ? this : otherFile;
        if (!srcFile.exists()) {
            return;
        }
        String direction = outgoing ? "to" : "from";
        log.trace("Copying " + direction + " " + otherFile.getURI().getPath());
        if (outgoing) {
            this.writeContentTo(otherFile.getOutputStream());
        } else {
            this.readContentFrom(otherFile.getInputStream());
        }
        log.trace("Finished file copy");
    }

    public void readContentFrom(InputStream in) throws HandleOperationException {
        try {
            IOUtils.pipeStreams(in, this.getOutputStream(), true);
        }
        catch (IOException ioex) {
            throw new HandleOperationException("I/O error reading contents from file", ioex);
        }
    }

    public void writeContentTo(OutputStream out) throws HandleOperationException {
        try {
            IOUtils.pipeStreams(this.getInputStream(), out, true);
        }
        catch (IOException ioex) {
            throw new HandleOperationException("I/O error reading contents from file", ioex);
        }
    }

    public abstract FileHandle[] getChildren() throws HandleOperationException;

    public abstract long getSize() throws HandleOperationException;

    public String getPath() {
        return this.getURI().getPath();
    }

    public String getParent() {
        return this.getURI().getPath().substring(0, this.getURI().getPath().lastIndexOf(47));
    }
}

