/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems;

import java.util.Arrays;
import java.util.List;
import org.gwe.drivers.Driver;
import org.gwe.drivers.HandleCreationNotSupportedException;
import org.gwe.drivers.fileSystems.FileHandle;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemDriver<HANDLE_TYPE extends FileHandle>
extends Driver<HANDLE_TYPE, URILink> {
    private static final Object ALL_FILE_SYSTEMS = "*";

    @Override
    public Class<URILink> getHandleParamsClass() {
        return URILink.class;
    }

    public boolean canCreateHandleInCurrentEnvironment() {
        return true;
    }

    protected final void checkSchemeIsSupported(URILink link, String ... supportedSchemes) throws HandleCreationNotSupportedException {
        String linkScheme = link.getURI().getScheme();
        List<String> schemes = Arrays.asList(supportedSchemes);
        if (linkScheme == null) {
            linkScheme = "file";
        }
        if (schemes.contains(linkScheme) || schemes.contains(ALL_FILE_SYSTEMS)) {
            return;
        }
        throw new HandleCreationNotSupportedException("Scheme '" + linkScheme + "' not supported by driver '" + this.getClass() + "'");
    }
}

