/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.gwe.drivers.DriversManager;
import org.gwe.drivers.HandleCreationException;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.fileSystems.FileHandle;
import org.gwe.drivers.fileSystems.FileSystemDriver;
import org.gwe.utils.IOUtils;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.URILink;
import org.gwe.utils.services.BrokeredService;
import org.gwe.utils.services.PlainService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridFileSystem
extends DriversManager<FileSystemDriver<FileHandle>, FileHandle, URILink> {
    private static Log log = LogFactory.getLog(GridFileSystem.class);
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LOCAL_FS_SCHEME = "file://";
    public static final String SFTP_FS_SCHEME = "sftp://";
    private Map<String, Integer> downloadParallelSizes;
    private Map<String, Integer> uploadParallelSizes;
    private Map<String, BrokeredService<Long>> fileTransferServices = new HashMap<String, BrokeredService<Long>>();
    private BrokeredService<Long> fileTransferService;
    private BrokeredService<Long> uploadFileTransferService = new BrokeredService(10, "Upload File Transfer Service");

    public GridFileSystem(List<FileSystemDriver<FileHandle>> drivers, Map<String, Integer> downloadParallelSizes, Map<String, Integer> uploadParallelSizes) {
        super(drivers);
        this.downloadParallelSizes = downloadParallelSizes;
        this.uploadParallelSizes = uploadParallelSizes;
    }

    public GridFileSystem(List<FileSystemDriver<FileHandle>> drivers, int maxParallelFileTransfers) {
        super(drivers);
        this.fileTransferService = new BrokeredService(maxParallelFileTransfers, "File Transfer Service");
    }

    public BrokeredService<Long> getFileTransferer(String srcFile, String destFile) {
        return this.fileTransferService;
    }

    public FileHandle createHandle(String uri, KeyStore keys) throws HandleCreationException {
        URI formattedURI = this.formatURI(uri);
        URILink link = keys != null ? keys.generateURILink(formattedURI) : URILink.createLocalLink(formattedURI);
        return (FileHandle)this.createHandle(link);
    }

    public FileHandle createHandle(String uriStr, AccountInfo account) throws HandleCreationException {
        try {
            return (FileHandle)this.createHandle(new URILink(account, new URI(this.formatAsLocalSFTP(uriStr))));
        }
        catch (URISyntaxException e) {
            throw new HandleCreationException(e);
        }
    }

    private URI formatURI(String uriStr) throws HandleCreationException {
        try {
            return new URI(this.formatURIStr(uriStr));
        }
        catch (URISyntaxException e) {
            String msg = "Could not format file URI '" + uriStr + "'";
            log.warn(msg);
            throw new HandleCreationException(msg, e);
        }
    }

    private String formatURIStr(String uriStr) throws HandleCreationException {
        if (uriStr.charAt(0) == '.') {
            try {
                return LOCAL_FS_SCHEME + new File(".").getCanonicalPath() + uriStr.substring(1);
            }
            catch (Exception e) {
                log.warn("Error trying to reformat URL provided by user. Using provided URL '" + uriStr + "'");
            }
        }
        if (uriStr.indexOf("://") == -1) {
            return LOCAL_FS_SCHEME + uriStr;
        }
        return uriStr;
    }

    private String formatAsLocalSFTP(String uriStr) throws HandleCreationException {
        String formattedURIStr = this.formatURIStr(uriStr);
        if (this.getLocalHostName() == null) {
            return formattedURIStr;
        }
        return formattedURIStr.replace(LOCAL_FS_SCHEME, SFTP_FS_SCHEME + this.getLocalHostName());
    }

    public Long stageFile(String srcFile, String destFile, KeyStore keys) throws Exception {
        return this.transferFile(this.formatAsLocalSFTP(srcFile), this.formatAsLocalSFTP(destFile), keys);
    }

    public Long transferFile(String srcFile, String destFile, KeyStore keys) throws Exception {
        return this.transferFile(this.getFileTransferer(srcFile, destFile), srcFile, destFile, keys);
    }

    public Long uploadFile(String srcFile, String destFile, KeyStore keys) throws Exception {
        return this.transferFile(this.uploadFileTransferService, srcFile, destFile, keys);
    }

    public Long transferFile(BrokeredService<Long> fileTransferService, final String srcFile, final String destFile, final KeyStore keys) throws Exception {
        return fileTransferService.processRequestBlocking(new PlainService<Long>(){

            @Override
            public Long runService() throws Exception {
                return GridFileSystem.this.transferFileSync(srcFile, destFile, keys);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long transferFileSync(String srcFile, String destFile, KeyStore keys) throws Exception {
        FileHandle destFileHandle;
        FileHandle srcFileHandle;
        block7: {
            long l2;
            log.info("Transfering file from '" + srcFile + "' to '" + destFile + "'");
            srcFileHandle = null;
            destFileHandle = null;
            try {
                srcFileHandle = this.createHandle(srcFile, keys);
                try {
                    if (srcFileHandle.exists()) break block7;
                    l2 = 0L;
                }
                catch (Exception e) {
                    // empty catch block
                    break block7;
                }
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    this.cleanUpHandle(srcFileHandle);
                    this.cleanUpHandle(destFileHandle);
                    throw throwable;
                }
            }
            this.cleanUpHandle(srcFileHandle);
            this.cleanUpHandle(destFileHandle);
            return l2;
        }
        destFileHandle = this.createHandle(destFile, keys);
        srcFileHandle.copy(true, destFileHandle);
        long result = destFileHandle.getSize();
        log.info("File transfer operation completed! ('" + srcFile + "' --> '" + destFile + "')");
        long l = result;
        this.cleanUpHandle(srcFileHandle);
        this.cleanUpHandle(destFileHandle);
        return l;
    }

    private void cleanUpHandle(FileHandle handle) throws HandleOperationException {
        if (handle != null) {
            handle.close();
            handle = null;
        }
    }

    public Map<String, String> findGlobFilesAndMatches(URILink link) throws HandleOperationException {
        TreeMap<String, String> res = new TreeMap<String, String>();
        Pattern patternObj = this.getPattern(link.getURI().getPath());
        Perl5Matcher matcher = new Perl5Matcher();
        for (FileHandle currFile : this.getAllFileHandlers(link)) {
            if (!matcher.matches(currFile.getPath(), patternObj)) continue;
            String match = ((Object)matcher.getMatch()).toString();
            res.put(currFile.getPath(), match);
            log.trace("Found " + currFile.getPath() + " matching " + match);
        }
        return res;
    }

    public List<FileHandle> findGlobFiles(URILink link) throws HandleOperationException {
        ArrayList<FileHandle> res = new ArrayList<FileHandle>();
        Pattern patternObj = this.getPattern(link.getURI().getPath());
        Perl5Matcher matcher = new Perl5Matcher();
        for (FileHandle currFile : this.getAllFileHandlers(link)) {
            if (!matcher.matches(currFile.getURI().getPath(), patternObj)) continue;
            ((Object)matcher.getMatch()).toString();
            log.trace("Found " + currFile.getURI().getPath());
            res.add(currFile);
        }
        return res;
    }

    public List<String> findWildcardMatches(URILink link) throws HandleOperationException {
        ArrayList<String> res = new ArrayList<String>();
        Pattern patternObj = this.getPattern(link.getURI().getPath());
        Perl5Matcher matcher = new Perl5Matcher();
        for (FileHandle currFile : this.getAllFileHandlers(link)) {
            String currFilePath = currFile.getURI().getPath();
            if (!matcher.matches(currFilePath, patternObj)) continue;
            MatchResult match = matcher.getMatch();
            res.add(((Object)match).toString());
        }
        Collections.sort(res);
        return res;
    }

    private Pattern getPattern(String uriPath) throws HandleOperationException {
        boolean listRecursively = uriPath.matches(".*\\*\\*.*");
        String glob = uriPath.replaceAll("//", FILE_SEPARATOR);
        log.trace("Checking glob " + glob + ".  Recursive? " + listRecursively);
        try {
            return new GlobCompiler().compile(glob);
        }
        catch (MalformedPatternException mpex) {
            throw new HandleOperationException("Glob syntax error", mpex);
        }
    }

    private List<FileHandle> getAllFileHandlers(URILink link) throws HandleOperationException {
        String uriStr = link.getURI().toString();
        boolean listRecursively = uriStr.matches(".*\\*\\*.*");
        String base = IOUtils.getFileBase(uriStr);
        log.trace("Testing base directory " + base);
        try {
            FileHandle root = (FileHandle)this.createHandle(new URILink(link.getAccountInfo(), new URI(base)));
            List<FileHandle> files = this.listFiles(root, listRecursively);
            log.trace("Found " + files.size() + " files.");
            return files;
        }
        catch (Exception ex) {
            throw new HandleOperationException("Could not find path for globbing", ex);
        }
    }

    private List<FileHandle> listFiles(FileHandle file, boolean recurse) throws Exception {
        ArrayList<FileHandle> res = new ArrayList<FileHandle>();
        if (!file.isDirectory()) {
            if (file.exists()) {
                res.add(file);
            }
        } else {
            for (FileHandle child : file.getChildren()) {
                if (child.isDirectory() && recurse) {
                    res.addAll(this.listFiles(child, recurse));
                    continue;
                }
                if (child.isDirectory()) continue;
                res.add(child);
            }
        }
        return res;
    }
}

