/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems;

import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.HandleCreationException;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.fileSystems.FileSystemDriver;
import org.gwe.drivers.fileSystems.JargonHandle;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JargonDriver
extends FileSystemDriver<JargonHandle> {
    public static final String DOMAIN = "DOMAIN";
    public static final String DEFAULT_STORAGE_RESOURCE = "DEFAULT STORAGE RESOURCE";
    private static Log log = LogFactory.getLog(JargonDriver.class);

    @Override
    public JargonHandle tryToCreateHandle(URILink link) throws HandleCreationException {
        this.checkSchemeIsSupported(link, "srb");
        URI uri = link.getURI();
        AccountInfo acctInfo = link.getAccountInfo();
        SRBAccount account = new SRBAccount(uri.getHost(), uri.getPort(), acctInfo.getUserName(), "", acctInfo.getHomeDir(), acctInfo.getProperty(DOMAIN), acctInfo.getProperty(DEFAULT_STORAGE_RESOURCE));
        account.setOptions(51);
        log.info("Setting credential " + acctInfo.getAccountName() + " for file '" + uri + "'");
        account.setGSSCredential(acctInfo.getCredential());
        try {
            SRBFileSystem srbFS = new SRBFileSystem(account);
            SRBFile srbFile = new SRBFile(srbFS, uri.getPath());
            return new JargonHandle(link, srbFile);
        }
        catch (Exception e) {
            throw new HandleCreationException(e);
        }
    }
}

