/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.fileSystems.FileHandle;
import org.gwe.utils.security.URILink;

class JargonHandle
extends FileHandle {
    private GeneralFile fileObj;

    public JargonHandle(URILink link, GeneralFile generalFile) {
        super(link);
        this.fileObj = generalFile;
    }

    public boolean exists() throws HandleOperationException {
        return this.fileObj.exists();
    }

    public boolean isDirectory() throws HandleOperationException {
        return this.fileObj.isDirectory();
    }

    public void create() throws HandleOperationException {
        if (this.exists()) {
            return;
        }
        if (this.isDirectory()) {
            this.fileObj.mkdirs();
        } else {
            try {
                this.fileObj.createNewFile();
            }
            catch (IOException e) {
                throw new HandleOperationException("Could not create new file '" + this.fileObj.getName() + "'", e);
            }
        }
    }

    public InputStream getInputStream() throws HandleOperationException {
        try {
            return FileFactory.newFileInputStream(this.fileObj);
        }
        catch (IOException e) {
            throw new HandleOperationException("Could not get file input stream for file '" + this.fileObj.getName() + "'", e);
        }
    }

    public OutputStream getOutputStream() throws HandleOperationException {
        try {
            return FileFactory.newFileOutputStream(this.fileObj);
        }
        catch (IOException e) {
            throw new HandleOperationException("Could not get file output stream for file '" + this.fileObj.getName() + "'", e);
        }
    }

    public long getSize() throws HandleOperationException {
        return this.isDirectory() ? -1L : this.fileObj.length();
    }

    public FileHandle[] getChildren() throws HandleOperationException {
        GeneralFile[] files = this.fileObj.listFiles();
        FileHandle[] res = new FileHandle[files.length];
        for (int idx = 0; idx < res.length; ++idx) {
            URILink currLink = new URILink(this.link.getAccountInfo(), files[idx].toURI());
            res[idx] = new JargonHandle(currLink, files[idx]);
        }
        return res;
    }
}

