/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.sftp.SftpPPKAuth;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.fileSystems.FileSystemDriver;
import org.gwe.drivers.fileSystems.VfsHandle;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VfsDriver
extends FileSystemDriver<VfsHandle> {
    private static Log log = LogFactory.getLog(VfsDriver.class);
    private static FileSystemManager vfsManager = null;

    public VfsDriver() throws HandleOperationException {
        try {
            if (vfsManager == null) {
                vfsManager = VFS.getManager();
            }
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Unable to connect to the manager; this is probably fatal", fex);
        }
    }

    @Override
    public VfsHandle tryToCreateHandle(URILink link) throws Exception {
        FileObject fileObj;
        this.checkSchemeIsSupported(link, "file", "http", "sftp");
        String uriStr = link.getURI().toString();
        if (link.getAccountInfo() != null) {
            log.info("Setting credential \"" + link.getAccountInfo().getAccountName() + "\" for file '" + link.getURI().getPath() + "'");
            fileObj = vfsManager.resolveFile(uriStr, this.createOptions(link));
        } else {
            fileObj = vfsManager.resolveFile(uriStr);
        }
        return new VfsHandle(link, fileObj);
    }

    private FileSystemOptions createOptions(URILink link) throws FileSystemException {
        AccountInfo acct = link.getAccountInfo();
        FileSystemOptions opts = new FileSystemOptions();
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, new AuthBridge(acct));
        if (link.getURI().getScheme().equals("sftp") && acct.getPassword() == null) {
            SftpPPKAuth ppkAuth = new SftpPPKAuth(acct.getPrivateKey(), acct.getPublicKey(), acct.getPassphrase());
            SftpFileSystemConfigBuilder.getInstance().setPPKAuth(opts, ppkAuth);
        }
        return opts;
    }

    class AuthBridge
    implements UserAuthenticator {
        private String userName;
        private String password;

        AuthBridge(AccountInfo account) {
            this.userName = account.getUserName();
            this.password = account.getPassword();
        }

        public UserAuthenticationData requestAuthentication(UserAuthenticationData.Type[] types) {
            UserAuthenticationData res = new UserAuthenticationData();
            for (int ii = 0; ii < types.length; ++ii) {
                if (types[ii].equals(UserAuthenticationData.USERNAME)) {
                    res.setData(types[ii], this.userName.toCharArray());
                    continue;
                }
                if (types[ii].equals(UserAuthenticationData.PASSWORD)) {
                    res.setData(types[ii], this.password != null ? this.password.toCharArray() : null);
                    continue;
                }
                throw new UnsupportedOperationException("Domain-based authentication not supported.");
            }
            return res;
        }
    }
}

