/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.fileSystems.FileHandle;
import org.gwe.utils.security.URILink;

class VfsHandle
extends FileHandle {
    private static Log log = LogFactory.getLog(VfsHandle.class);
    private FileObject fileObj;

    public VfsHandle(URILink link, FileObject wrapee) {
        super(link);
        this.fileObj = wrapee;
    }

    public void create() throws HandleOperationException {
        if (this.exists()) {
            return;
        }
        try {
            if (this.isDirectory()) {
                this.fileObj.createFolder();
            } else {
                this.fileObj.createFile();
            }
        }
        catch (FileSystemException e) {
            throw new HandleOperationException("Error creating file", e);
        }
    }

    public boolean exists() throws HandleOperationException {
        try {
            return this.fileObj.exists();
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Could not check file existence", fex);
        }
    }

    public boolean isDirectory() throws HandleOperationException {
        try {
            return this.fileObj.getType().hasChildren();
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Could not check directoriness", fex);
        }
    }

    public void copy(boolean outgoing, FileHandle otherFile) throws HandleOperationException {
        super.copy(outgoing, otherFile);
        try {
            this.fileObj.close();
            ((VfsHandle)otherFile).fileObj.close();
        }
        catch (FileSystemException e) {
            throw new HandleOperationException("Could not close internal file handles", e);
        }
    }

    public InputStream getInputStream() throws HandleOperationException {
        try {
            return this.fileObj.getContent().getInputStream();
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Could not read contents from file '" + this.link.getURI().getPath() + "'", fex);
        }
    }

    public OutputStream getOutputStream() throws HandleOperationException {
        try {
            return this.fileObj.getContent().getOutputStream();
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Could not create contents for file '" + this.link.getURI().getPath() + "'", fex);
        }
    }

    public FileHandle[] getChildren() throws HandleOperationException {
        try {
            FileObject[] files = this.fileObj.getChildren();
            FileHandle[] res = new FileHandle[files.length];
            for (int idx = 0; idx < res.length; ++idx) {
                URI uri = new URI(this.getURI().getScheme(), null, files[idx].getName().getPath(), null);
                URILink currLink = new URILink(this.link.getAccountInfo(), uri);
                res[idx] = new VfsHandle(currLink, files[idx]);
            }
            return res;
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Error listing directory", fex);
        }
        catch (URISyntaxException uex) {
            throw new HandleOperationException("Invalid URL format", uex);
        }
    }

    public long getSize() throws HandleOperationException {
        try {
            return this.fileObj.getContent().getSize();
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Could not compute file size", fex);
        }
    }

    public boolean delete() throws HandleOperationException {
        try {
            this.fileObj.delete(new AllFileSelector());
            boolean deleted = this.fileObj.delete();
            return deleted;
        }
        catch (FileSystemException fex) {
            throw new HandleOperationException("Could not delete file", fex);
        }
    }

    public void close() throws HandleOperationException {
        try {
            this.fileObj.close();
        }
        catch (IOException e) {
            throw new HandleOperationException("Could not close file", e);
        }
    }
}

