/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems.staging;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.fileSystems.staging.DownloadHandleRepo;
import org.gwe.drivers.fileSystems.staging.FilesStager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadHandle
implements Comparable<DownloadHandle> {
    private static Log log = LogFactory.getLog(DownloadHandle.class);
    static long CANNOT_FREE_NOW_SIZE = -1L;
    String localFile;
    private FilesStager stager;
    private Future<Long> result;
    private DownloadHandleRepo repo;
    private long size = CANNOT_FREE_NOW_SIZE;
    private Long lastTimeAccessed = System.currentTimeMillis();
    private int clients = 0;
    private Boolean garbageCollected = false;

    DownloadHandle(String downloadedFile, FilesStager stager, Future<Long> future, DownloadHandleRepo repo) {
        this.localFile = downloadedFile;
        this.stager = stager;
        this.result = future;
        this.repo = repo;
    }

    public String getLocalFileWhenReady() throws InterruptedException, ExecutionException {
        this.size = this.result.get();
        return this.localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long garbageCollect(boolean disposeAssociatedFile) {
        DownloadHandleRepo downloadHandleRepo = this.repo;
        synchronized (downloadHandleRepo) {
            if (this.clients > 0) {
                return CANNOT_FREE_NOW_SIZE;
            }
            if (disposeAssociatedFile) {
                this.stager.cleanUp(this.localFile);
            }
            log.info("Garbage collecting download: " + this.toString());
            this.garbageCollected = true;
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() {
        DownloadHandleRepo downloadHandleRepo = this.repo;
        synchronized (downloadHandleRepo) {
            if (this.garbageCollected.booleanValue()) {
                return false;
            }
            ++this.clients;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        DownloadHandleRepo downloadHandleRepo = this.repo;
        synchronized (downloadHandleRepo) {
            --this.clients;
            if (this.clients == 0) {
                this.lastTimeAccessed = System.currentTimeMillis();
            }
        }
    }

    @Override
    public int compareTo(DownloadHandle other) {
        return this.clients > 0 ? 1 : (int)(this.lastTimeAccessed - other.lastTimeAccessed);
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return this.localFile + "[" + this.clients + "-" + this.garbageCollected + "]=" + this.size + ";" + (System.currentTimeMillis() - this.lastTimeAccessed) / 1000L + " secs ago";
    }
}

