/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems.staging;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.fileSystems.staging.DownloadHandle;
import org.gwe.drivers.fileSystems.staging.FilesStager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadHandleRepo
implements Runnable {
    private static Log log = LogFactory.getLog(DownloadHandleRepo.class);
    private static long BYTES_IN_GYGABYTE = 0x40000000L;
    private static DownloadHandleRepo instance = null;
    private Set<DownloadHandle> repo = new TreeSet<DownloadHandle>();
    private long repoSize;
    private int filesDownloadedSinceLastGC = 0;

    public static DownloadHandleRepo getInstance() {
        if (instance == null) {
            instance = new DownloadHandleRepo(0.1);
        }
        return instance;
    }

    public DownloadHandleRepo(double gigabytes) {
        this.repoSize = (long)(gigabytes * (double)BYTES_IN_GYGABYTE);
        new Thread((Runnable)this, "BG Service - Virtual Cache FS Garbage Collector").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadHandle createHandle(String downloadedFile, FilesStager stager, Future<Long> future) {
        DownloadHandle handle = new DownloadHandle(downloadedFile, stager, future, this);
        DownloadHandleRepo downloadHandleRepo = this;
        synchronized (downloadHandleRepo) {
            this.repo.add(handle);
            ++this.filesDownloadedSinceLastGC;
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGarbageCollection() {
        DownloadHandleRepo downloadHandleRepo = this;
        synchronized (downloadHandleRepo) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            DownloadHandleRepo downloadHandleRepo = this;
            synchronized (downloadHandleRepo) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.garbageCollectAsNeeded();
            }
        }
    }

    private void garbageCollectAsNeeded() {
        long memoryCount = this.repoSize;
        HashSet<DownloadHandle> removedHandles = new HashSet<DownloadHandle>();
        for (DownloadHandle handle : this.repo) {
            long handleSize;
            if (memoryCount > 0L) {
                handleSize = handle.getSize();
                if (handleSize != DownloadHandle.CANNOT_FREE_NOW_SIZE) {
                    memoryCount -= handleSize;
                }
            } else {
                handleSize = handle.garbageCollect(true);
                if (handleSize != DownloadHandle.CANNOT_FREE_NOW_SIZE) {
                    removedHandles.add(handle);
                }
            }
            this.repo.removeAll(removedHandles);
        }
        this.filesDownloadedSinceLastGC = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeDownloadsUnder(String topLevelFolder) {
        DownloadHandleRepo downloadHandleRepo = this;
        synchronized (downloadHandleRepo) {
            HashSet<DownloadHandle> removedHandles = new HashSet<DownloadHandle>();
            for (DownloadHandle handle : this.repo) {
                if (handle.localFile == null || !handle.localFile.startsWith(topLevelFolder)) continue;
                handle.garbageCollect(false);
                removedHandles.add(handle);
            }
            this.repo.removeAll(removedHandles);
        }
    }
}

