/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems.staging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.drivers.HandleCreationException;
import org.gwe.drivers.fileSystems.staging.DownloadHandle;
import org.gwe.drivers.fileSystems.staging.DownloadHandleRepo;
import org.gwe.drivers.fileSystems.staging.FileStagingException;
import org.gwe.drivers.fileSystems.staging.StagingUtils;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.utils.concurrent.ThreadPoolUtils;
import org.gwe.utils.security.KeyStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesStager {
    private static Log log = LogFactory.getLog(FilesStager.class);
    private static ExecutorService downloadersThreadPool = ThreadPoolUtils.createThreadPool("File Downloaders");
    private Map<String, DownloadHandle> downloadsCache = new HashMap<String, DownloadHandle>();
    private KeyStore keys;
    private String downloadFolder;
    private NetworkAccessHandle[] localAccess = new NetworkAccessHandle[3];

    public FilesStager(String downloadFolder, KeyStore keys) {
        this.downloadFolder = downloadFolder;
        this.keys = keys;
        try {
            for (int idx = 0; idx < 3; ++idx) {
                this.localAccess[idx] = GWEAppContext.getGridNetworkAccess().createLocalHandle(keys);
            }
        }
        catch (HandleCreationException handleCreationException) {
            // empty catch block
        }
    }

    public void downloadFiles(Map<String, String> fileTransfers) throws FileStagingException {
        HashMap<String, DownloadHandle> handles = new HashMap<String, DownloadHandle>();
        log.info("Ready to request downloads: " + fileTransfers);
        for (String remoteFile : fileTransfers.keySet()) {
            handles.put(remoteFile, this.downloadFile(remoteFile));
        }
        DownloadHandleRepo.getInstance().startGarbageCollection();
        HashMap<String, String> downloadLocations = new HashMap<String, String>();
        for (String remoteFile : handles.keySet()) {
            try {
                downloadLocations.put(remoteFile, ((DownloadHandle)handles.get(remoteFile)).getLocalFileWhenReady());
            }
            catch (ExecutionException e) {
                throw new FileStagingException("Exception encountered while downloading file " + remoteFile, e.getCause());
            }
            catch (Exception e) {
                throw new FileStagingException("Exception encountered while downloading file " + remoteFile, e);
            }
        }
        this.mirrorFiles(fileTransfers, handles, downloadLocations);
        handles.clear();
        downloadLocations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadHandle downloadFile(final String remoteFile) {
        DownloadHandle handle;
        Map<String, DownloadHandle> map = this.downloadsCache;
        synchronized (map) {
            handle = this.downloadsCache.get(remoteFile);
            if (handle == null || !handle.lock()) {
                log.info("Cached of file '" + remoteFile + "' not found in virtual cache FS. Downloading it...");
                final String downloadedFile = StagingUtils.getLocalFileName(this.downloadFolder, remoteFile, "cache-" + this.downloadsCache.size());
                Future<Long> future = downloadersThreadPool.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        return GWEAppContext.getGridFileSystem().stageFile(remoteFile, downloadedFile, FilesStager.this.keys);
                    }
                });
                handle = DownloadHandleRepo.getInstance().createHandle(downloadedFile, this, future);
                this.downloadsCache.put(remoteFile, handle);
            } else {
                log.info("Cached of file '" + remoteFile + "' found in virtual cache FS!");
            }
        }
        return handle;
    }

    private void mirrorFiles(Map<String, String> fileTransfers, Map<String, DownloadHandle> handles, Map<String, String> downloadLocations) throws FileStagingException {
        log.info("Downloads ready to be copied from cached virtual file system: " + downloadLocations);
        ArrayList<String[]> mirrors = new ArrayList<String[]>();
        for (String remoteFile : fileTransfers.keySet()) {
            String src = downloadLocations.get(remoteFile);
            String dest = fileTransfers.get(remoteFile);
            mirrors.add(new String[]{src, dest});
        }
        int count = 0;
        String[] cmds = new String[mirrors.size() * 2];
        for (String[] mirror : mirrors) {
            cmds[count] = this.createFileDirCmd(mirror[1]);
            cmds[count + 1] = "cp " + mirror[0] + " " + mirror[1];
            count += 2;
        }
        try {
            this.runLocalCommands(0, cmds);
        }
        catch (Exception e) {
            throw new FileStagingException("Problem encountered while copying mirroring files. File Transfers: " + fileTransfers + "Download Locations: " + downloadLocations, e);
        }
        for (String remoteFile : fileTransfers.keySet()) {
            handles.get(remoteFile).unlock();
        }
    }

    public void prepareUploadDirectories(Map<String, String> uploads) throws FileStagingException {
        int count = 0;
        String[] cmds = new String[uploads.size()];
        for (String localFile : uploads.keySet()) {
            cmds[count] = this.createFileDirCmd(localFile);
            ++count;
        }
        try {
            this.runLocalCommands(1, cmds);
        }
        catch (ConnectorException e) {
            throw new FileStagingException("Problems encountered while creating temporary destinations for files to stage out: " + uploads, e);
        }
    }

    public void uploadFiles(Map<String, String> uploads) throws FileStagingException {
        for (String localFile : uploads.keySet()) {
            String remoteFile = uploads.get(localFile);
            try {
                GWEAppContext.getGridFileSystem().uploadFile(localFile, remoteFile, this.keys);
            }
            catch (Exception e) {
                throw new FileStagingException("Exception encountered while uploading file '" + localFile + "' to '" + remoteFile + "'", e);
            }
        }
    }

    public void cleanUp(String workspacePath) {
        if (workspacePath != null && !"".equals(workspacePath)) {
            try {
                this.runLocalCommands(2, "rm -fdr " + workspacePath);
            }
            catch (ConnectorException e) {
                log.warn("Couldn't clean up file system entry " + workspacePath, e);
            }
        }
    }

    public void dispose() {
        this.cleanUp(this.downloadFolder);
        DownloadHandleRepo.getInstance().disposeDownloadsUnder(this.downloadFolder);
        for (int idx = 0; idx < 3; ++idx) {
            try {
                this.localAccess[idx].close();
                continue;
            }
            catch (ConnectorException connectorException) {
                // empty catch block
            }
        }
    }

    private String createFileDirCmd(String file) {
        return "mkdir -p " + file.substring(0, file.lastIndexOf("/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLocalCommands(int accessorId, String ... cmds) throws ConnectorException {
        NetworkAccessHandle networkAccessHandle = this.localAccess[accessorId];
        synchronized (networkAccessHandle) {
            for (String cmd : cmds) {
                this.localAccess[accessorId].runCommand(cmd);
            }
        }
    }
}

