/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.fileSystems.staging;

import java.util.HashMap;
import java.util.Map;
import org.gwe.drivers.fileSystems.staging.StagingUtils;
import org.gwe.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesTransferDescriptor {
    private Map<String, String> repo = new HashMap<String, String>();

    public FilesTransferDescriptor(String prefixDir, String[] potentialTransfers, String workspace) {
        for (String pTransfer : potentialTransfers) {
            if (!pTransfer.startsWith(prefixDir)) continue;
            String[] pieces = StringUtils.splitBoundaries(pTransfer, prefixDir + "[", "]:");
            String newName = pieces != null && pieces.length > 4 && pieces[2] != null ? pieces[2] : null;
            this.repo.put(pTransfer, StagingUtils.getLocalFileName(workspace, this.getURI(pTransfer), newName));
        }
    }

    public Map<String, String> getFileTransfers(boolean asURIs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String remoteFile : this.repo.keySet()) {
            if (asURIs) {
                result.put(this.getURI(remoteFile), this.repo.get(remoteFile));
                continue;
            }
            result.put(" " + remoteFile, " " + this.repo.get(remoteFile));
        }
        return result;
    }

    private String getURI(String remoteFile) {
        return remoteFile.substring(remoteFile.indexOf(58) + 1);
    }
}

