/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.netAccess;

import java.net.URISyntaxException;
import java.util.List;
import org.gwe.drivers.DriversManager;
import org.gwe.drivers.HandleCreationException;
import org.gwe.drivers.netAccess.NetworkAccessDriver;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.utils.security.KeyStore;
import org.gwe.utils.security.URILink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridNetworkAccess
extends DriversManager<NetworkAccessDriver<NetworkAccessHandle>, NetworkAccessHandle, URILink> {
    public static final String SSH_NET_SCHEME = "ssh://";

    public GridNetworkAccess(List<NetworkAccessDriver<NetworkAccessHandle>> drivers) {
        super(drivers);
    }

    public NetworkAccessHandle createLocalHandle(KeyStore keys) throws HandleCreationException {
        return this.createHandle(SSH_NET_SCHEME + this.getLocalHostName(), keys);
    }

    public NetworkAccessHandle createHandle(URILink link, KeyStore keys) throws HandleCreationException {
        return link == null || link.getURI() == null ? (NetworkAccessHandle)this.createHandle() : this.createHandle(link.getURI().toString(), keys);
    }

    public NetworkAccessHandle createHandle(String uri, KeyStore keys) throws HandleCreationException {
        try {
            return (NetworkAccessHandle)this.createHandle(keys.generateURILink(uri));
        }
        catch (URISyntaxException e) {
            throw new HandleCreationException(e);
        }
    }

    public NetworkAccessHandle createHandle(URILink link, String privateKeyTempFolder) throws HandleCreationException {
        for (NetworkAccessDriver driver : this.drivers) {
            try {
                return driver.tryToCreateHandle(link, privateKeyTempFolder);
            }
            catch (HandleCreationException e) {
            }
        }
        throw new HandleCreationException("There was no driver able to create a handle for '" + link + "'");
    }
}

