/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.netAccess;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.utils.security.AccountInfo;
import org.gwe.utils.security.URILink;

public class JSchConnection {
    private static Log log = LogFactory.getLog(JSchConnection.class);
    private URILink link;
    private JSch jschObj;
    private Session sessionObj;

    public JSchConnection(URILink link) throws JSchException, UnknownHostException {
        this.link = link;
        AccountInfo acct = link.getAccountInfo();
        log.debug("Creating ssh connector for " + acct.getUserName() + "@" + link.getURI());
        this.jschObj = this.createJSchObject(acct.getPrivateKey(), acct.getPublicKey(), acct.getPassphrase());
        this.sessionObj = this.createJSchSession();
    }

    private JSch createJSchObject(byte[] privateKey, byte[] publicKey, String passphrase) throws JSchException {
        JSch result = new JSch();
        result.setKnownHosts(System.getProperty("user.home") + "/.ssh/known_hosts");
        if (privateKey != null) {
            result.addIdentity("byte-array", privateKey, publicKey, passphrase.getBytes());
        }
        return result;
    }

    private Session createJSchSession() throws JSchException, UnknownHostException {
        AccountInfo acct = this.link.getAccountInfo();
        String host = this.link != null && this.link.getURI() != null ? this.link.getURI().getHost() : InetAddress.getLocalHost().getHostName();
        log.info("Connecting to " + acct.getUserName() + "@" + host);
        Session sessObj = this.jschObj.getSession(acct.getUserName(), host);
        if (acct.getPassword() != null) {
            sessObj.setUserInfo(new FakeSchUserInfoImpl(acct));
        }
        sessObj.connect(30000);
        log.info("Successfully connected");
        return sessObj;
    }

    public URILink getLink() {
        return this.link;
    }

    public JSch getJschObj() {
        return this.jschObj;
    }

    public Session getSessionObj() {
        return this.sessionObj;
    }

    protected void finalize() throws Throwable {
        if (this.sessionObj != null) {
            this.sessionObj.disconnect();
        }
    }

    class FakeSchUserInfoImpl
    implements UserInfo {
        private AccountInfo account;

        public FakeSchUserInfoImpl(AccountInfo accountInfo) {
            this.account = accountInfo;
        }

        public String getPassphrase() {
            return new String(this.account.getPassphrase());
        }

        public String getPassword() {
            return new String(this.account.getPassword());
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public boolean promptPassphrase(String string) {
            return this.account.getPassphrase() != null;
        }

        public boolean promptYesNo(String string) {
            return true;
        }

        public void showMessage(String string) {
        }
    }
}

