/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.netAccess;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.netAccess.ShellCommand;
import org.gwe.utils.IOUtils;
import org.gwe.utils.security.URILink;

class LocalHandle
extends NetworkAccessHandle {
    private static Log log = LogFactory.getLog(LocalHandle.class);

    public LocalHandle(URILink link) {
        super(link);
    }

    public LocalHandle() {
        this(URILink.createLocalLink(null));
    }

    public String runCommand(ShellCommand command) throws ConnectorException {
        if (command == null || command.getCmd() == null) {
            throw new NullPointerException("Cannot execute 'null' shell command.");
        }
        ProcessBuilder pb = new ProcessBuilder(command.getCmd().split(" "));
        if (command.getEnv() != null) {
            pb.environment().putAll(command.getEnv());
        }
        if (command.getPath() != null) {
            pb.directory(new File(command.getPath()));
        }
        try {
            log.info("Executing command '" + command.getCmd() + "'");
            Process processObj = pb.start();
            log.info("Command started '" + command.getCmd() + "'");
            String results = IOUtils.readStream(processObj.getInputStream(), command.getOutputStream()).toString();
            log.info("Command executed with results:\n" + results);
            return results;
        }
        catch (Exception ex) {
            throw new ConnectorException("Command execution failed: " + ex.getMessage(), ex);
        }
    }

    public void close() throws ConnectorException {
    }
}

