/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.netAccess;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.JSchConnection;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.netAccess.SSHDriver;
import org.gwe.drivers.netAccess.ShellCommand;
import org.gwe.utils.security.URILink;

class SSHHandle
extends NetworkAccessHandle {
    private static Log log = LogFactory.getLog(SSHDriver.class);
    private JSchConnection conn;

    public SSHHandle(URILink link) throws ConnectorException {
        super(link);
        try {
            this.conn = new JSchConnection(link);
        }
        catch (Exception ex) {
            log.info("Connection failed: aborting", ex);
            throw new ConnectorException("Jsch could not established a connection.", ex);
        }
    }

    public void openTunnel(int localPort, int remotePort) throws HandleOperationException {
        TunnelDescriptor tunnel = new TunnelDescriptor(localPort, this.link.getURI().getHost(), remotePort);
        try {
            this.conn.getSessionObj().delPortForwardingL(localPort);
        }
        catch (JSchException e1) {
            // empty catch block
        }
        try {
            this.conn.getSessionObj().setPortForwardingL(localPort, this.link.getURI().getHost(), remotePort);
            log.info("SSH tunnel created = " + tunnel);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    public String runCommand(ShellCommand command) throws ConnectorException {
        String res = null;
        try {
            log.info("Opening execution channel to " + this.link.getURI());
            ChannelExec channel = (ChannelExec)this.conn.getSessionObj().openChannel("exec");
            channel.setCommand(command.getUnixStyleCmd());
            channel.setErrStream(System.err);
            res = this.readChannel(channel, command.getExitToken(), command.getInactivityTimeout(), command.getOutputStream());
            channel.disconnect();
            log.info("Resulting command returned " + res.split("\n").length + " lines");
            log.trace("Command results:\n" + res);
        }
        catch (IOException e) {
            throw new ConnectorException("Error communicating with cluster", e);
        }
        catch (JSchException e) {
            throw new ConnectorException("SSH-level exception", e);
        }
        return res;
    }

    private String readChannel(ChannelExec channel, String exitToken, int inactivityTimeout, OutputStream os) throws IOException, JSchException {
        InputStream in = channel.getInputStream();
        channel.connect(30000);
        log.trace("Channel successfully connected");
        StringBuffer out = new StringBuffer();
        byte[] buff = new byte[1024];
        long startInactivity = System.currentTimeMillis();
        while (true) {
            if (in.available() > 0) {
                int count = in.read(buff);
                log.trace("Read " + count + " bytes");
                if (count >= 0) {
                    String readStr = new String(buff, 0, count);
                    if (os != null) {
                        os.write(readStr.getBytes());
                    }
                    out.append(readStr);
                    if (exitToken != null && out.lastIndexOf(exitToken) != -1) {
                        return out.toString();
                    }
                    startInactivity = System.currentTimeMillis();
                    continue;
                }
            }
            if (inactivityTimeout != -1 && System.currentTimeMillis() > startInactivity + (long)inactivityTimeout) {
                return out.toString();
            }
            if (channel.isClosed()) {
                log.info("Exit status: " + channel.getExitStatus());
                return out.toString();
            }
            try {
                Thread.yield();
            }
            catch (Exception ex) {
            }
        }
    }

    public void close() throws ConnectorException {
        log.info("Disconnecting from " + this.link.getURI());
        this.conn.getSessionObj().disconnect();
        this.conn = null;
    }

    class TunnelDescriptor {
        private int localPort;
        private String remoteHost;
        private int remotePort;

        public TunnelDescriptor(int localPort, String remoteHost, int remotePort) {
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public String toString() {
            return "[localhost:" + this.localPort + "] >==< [" + this.remoteHost + ":" + this.remotePort + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.localPort;
            result = 31 * result + (this.remoteHost == null ? 0 : this.remoteHost.hashCode());
            result = 31 * result + this.remotePort;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TunnelDescriptor other = (TunnelDescriptor)obj;
            if (this.localPort != other.localPort) {
                return false;
            }
            if (this.remoteHost == null ? other.remoteHost != null : !this.remoteHost.equals(other.remoteHost)) {
                return false;
            }
            return this.remotePort == other.remotePort;
        }
    }
}

