/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.netAccess;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellCommand {
    public static final int NON_INACTIVITY_TIMEOUT = -1;
    private String path;
    private String cmd;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env;
    private int inactivityTimeout = -1;
    private String exitToken = null;
    private OutputStream outputStream = null;

    public ShellCommand(String cmd) {
        this(cmd, null, null);
    }

    public ShellCommand(String cmd, String path, Map<String, String> env) {
        this.path = path;
        this.cmd = cmd;
        this.env = env;
    }

    public String getCmd() {
        return this.cmd;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public String getPath() {
        return this.path;
    }

    public int getNumArguments() {
        return this.args.size();
    }

    public String[] getArguments() {
        return this.args.toArray(new String[this.args.size()]);
    }

    public void addArgument(String s) {
        this.args.add(s);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.cmd);
        for (String arg : this.args) {
            sb.append(" " + arg);
        }
        return sb.toString();
    }

    public String getUnixStyleCmd() {
        StringBuffer envString = new StringBuffer();
        if (this.env != null) {
            for (String key : this.env.keySet()) {
                envString.append(" " + key + "=" + this.env.get(key));
            }
        }
        String realCmd = this.path != null ? "cd " + this.path + " && " : " ";
        realCmd = realCmd + envString.toString() + this.cmd;
        for (String arg : this.args) {
            realCmd = realCmd + " \"" + arg + "\"";
        }
        return realCmd;
    }

    public int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.inactivityTimeout = inactivityTimeout;
    }

    public String getExitToken() {
        return this.exitToken;
    }

    public void setExitToken(String exitToken) {
        this.exitToken = exitToken;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

