/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.osAppManagers;

import org.gwe.drivers.osAppManagers.OSAppFolder;
import org.gwe.drivers.osAppManagers.OSAppHandle;

public class JavaOSAppHandle
extends OSAppHandle {
    public static final String FATJAR_SUFFIX = "-fatjar.jar";
    private static final int NO_DEBUG_PORT = -1;
    private String mainClassName;
    private Object[] args = new Object[0];
    private int debugPort = -1;

    JavaOSAppHandle(String installationPath, String name, String version, String mainClassName) {
        super(installationPath, name, version);
        this.mainClassName = mainClassName;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public void resetDebugPort() {
        this.debugPort = -1;
    }

    public void setArgs(Object ... args) {
        if (args == null) {
            return;
        }
        this.args = args;
    }

    public String getArgs() {
        String result = "";
        for (Object arg : this.args) {
            result = result + "\"" + arg + "\" ";
        }
        return result;
    }

    public String getClasspath() {
        String libFolder = this.getFolderFullPath(OSAppFolder.LIBRARIES);
        return this.getFolderFullPath(OSAppFolder.CONFIGURATIONS) + ":" + libFolder + ":" + libFolder + "/" + this.getVersionedName() + FATJAR_SUFFIX;
    }

    public String getLaunchCommand() {
        String debugParams = this.debugPort == -1 ? "" : " -agentlib:jdwp=transport=dt_socket,server=y,address=" + this.debugPort;
        return "java -Xmx512m " + debugParams + " -cp " + this.getClasspath() + " " + this.mainClassName + " " + this.getArgs();
    }

    public JavaOSAppHandle clone() {
        JavaOSAppHandle result = new JavaOSAppHandle(this.installPath, this.name, this.version, this.mainClassName);
        result.setDebugPort(this.debugPort);
        return result;
    }
}

