/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.osAppManagers;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.GWEAppContext;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.netAccess.ShellCommand;
import org.gwe.drivers.osAppManagers.LaunchFailedException;
import org.gwe.drivers.osAppManagers.OSAppFolder;
import org.gwe.utils.security.URILink;

public class OSAppHandle
implements Serializable {
    private static Log log = LogFactory.getLog(OSAppHandle.class);
    protected String installPath;
    protected String name;
    protected String version;
    protected String launchCommand = "";
    private Map<OSAppFolder, String> foldersPath = new EnumMap<OSAppFolder, String>(OSAppFolder.class);

    OSAppHandle(String installationPath, String name, String version) {
        this.installPath = (installationPath.startsWith("/") ? "" : "/") + installationPath;
        this.name = name;
        this.version = version;
        for (OSAppFolder folder : OSAppFolder.values()) {
            this.foldersPath.put(folder, this.installPath + "/" + this.getVersionedName() + folder.toString());
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionedName() {
        return this.name + "-" + this.version;
    }

    public String getVersionedName(String bundleSuffix) {
        return this.getVersionedName() + bundleSuffix;
    }

    public String getFolderFullPath(OSAppFolder folder) {
        return folder == null || folder.equals((Object)OSAppFolder.ROOT) ? this.getInstallPath() : this.foldersPath.get((Object)folder);
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public String getLaunchCommand() {
        return this.launchCommand;
    }

    public void setLaunchCommand(String launchCommand) {
        this.launchCommand = launchCommand;
    }

    public void launch(URILink destLink, int timeout) throws HandleOperationException, ConnectorException {
        try {
            this.launch(destLink, timeout, null);
        }
        catch (LaunchFailedException launchFailedException) {
            // empty catch block
        }
    }

    public void launch(URILink destLink, int timeout, String exitToken) throws HandleOperationException, ConnectorException, LaunchFailedException {
        this.launch(destLink, this.getLaunchCommand(), this.getFolderFullPath(OSAppFolder.HOME), timeout, exitToken);
    }

    public void launch(URILink destLink, String launchCmd, String path, int timeout, String exitToken) throws HandleOperationException, ConnectorException, LaunchFailedException {
        ShellCommand cmd = new ShellCommand(launchCmd, path, null);
        cmd.setInactivityTimeout(timeout);
        if (exitToken != null) {
            cmd.setExitToken(exitToken);
        }
        String result = ((NetworkAccessHandle)GWEAppContext.getGridNetworkAccess().createHandle(destLink)).runCommand(cmd);
        if (exitToken != null && !result.contains(exitToken)) {
            throw new LaunchFailedException(launchCmd, result);
        }
    }
}

