/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.resManagers;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.HandleOperationException;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.resManagers.AllocationPhase;
import org.gwe.drivers.resManagers.ResourceAllocationException;
import org.gwe.drivers.resManagers.ResourceManagerHandle;
import org.gwe.persistence.model.AllocationInfo;

class CondorHandle
extends ResourceManagerHandle {
    private static Log log = LogFactory.getLog(CondorHandle.class);
    public static final String CONDOR_SUBMIT_FILE = "agent.condor.submit";
    private static String idPrefixToken = "submitted to cluster ";
    private static Pattern pattern = Pattern.compile(idPrefixToken + "(\\d+).");
    private static Map<String, AllocationPhase> statusFlags = new HashMap<String, AllocationPhase>();

    private final String getCondorSubmitContent(AllocationInfo alloc) {
        return "universe=vanilla\nexecutable=" + alloc.getWorkspacePath(this.getAgentScriptFileName(alloc)) + "\n" + "machine_count=1\n" + "getenv=TRUE\n" + "should_transfer_files=YES\n" + "when_to_transfer_output=ON_EXIT\n" + "notification=NEVER\n" + "error=agent.err\n" + "output=agent.out\n" + "log=agent.condor.log\n" + "transfer_input_files=\n" + "queue\n";
    }

    private String getAgentScriptFileName(AllocationInfo alloc) {
        return "agent-" + alloc.getHeadResource().getRegistryPort() + "-" + alloc.getId() + ".sh";
    }

    public CondorHandle(NetworkAccessHandle conn, JavaOSAppHandle agentOSApp) {
        super(conn, agentOSApp);
    }

    protected String queueAllocationRequest(AllocationInfo alloc, String agentLaunchCmd) throws ResourceAllocationException {
        try {
            this.writeScript(CONDOR_SUBMIT_FILE, this.getCondorSubmitContent(alloc), alloc);
            this.writeScript(this.getAgentScriptFileName(alloc), "#!/bin/bash\n" + agentLaunchCmd + "\n", alloc);
        }
        catch (Exception e) {
            String msg = "Could not prepare environment for condor job to launch allocation " + alloc.getId();
            log.warn(msg, e);
            throw new ResourceAllocationException(msg, e);
        }
        String scriptFullPath = alloc.getWorkspacePath(CONDOR_SUBMIT_FILE);
        String[] results = this.runQueueCommand("condor_submit " + scriptFullPath, alloc);
        String all = "";
        for (String line : results) {
            all = all + line;
        }
        log.info("Queueing results:\n" + all);
        String subResult = all.substring(all.lastIndexOf(idPrefixToken));
        Matcher matcher = pattern.matcher(subResult);
        return matcher.matches() ? matcher.group(0) : null;
    }

    private void writeScript(String scriptName, String content, AllocationInfo alloc) throws HandleOperationException {
        try {
            FileOutputStream fos = new FileOutputStream(alloc.getWorkspacePath(scriptName), false);
            fos.write(content.getBytes());
        }
        catch (IOException e) {
            throw new HandleOperationException(e);
        }
    }

    public AllocationPhase killAllocation(AllocationInfo alloc) throws ResourceAllocationException {
        String condorId = alloc.getSystemPid();
        if (condorId == null) {
            return AllocationPhase.RELEASED;
        }
        try {
            this.conn.runCommand("condor_rm " + condorId);
        }
        catch (ConnectorException e) {
            throw new ResourceAllocationException("Failed to kill allocation '" + alloc.getId() + "'", e);
        }
        return this.checkAllocation(alloc);
    }

    public AllocationPhase checkAllocation(AllocationInfo alloc) throws ResourceAllocationException {
        String condorId = alloc.getSystemPid();
        if (condorId == null) {
            return AllocationPhase.RELEASED;
        }
        try {
            AllocationPhase res = this.handleCondorOutput("condor_q", condorId);
            return res != null ? res : this.handleCondorOutput("condor_history", condorId);
        }
        catch (ConnectorException e) {
            throw new ResourceAllocationException("Failed to check system level status of allocation '" + alloc.getId() + "'", e);
        }
    }

    private AllocationPhase handleCondorOutput(String condorCmd, String condorId) throws ConnectorException {
        String results = this.conn.runCommand(condorCmd + " " + condorId);
        AllocationPhase res = null;
        for (String line : results.split("\n")) {
            String[] chunks = line.split("\\s+");
            if (chunks.length < 9 || !chunks[0].equals(condorId + ".0")) continue;
            res = statusFlags.get(chunks[5]);
        }
        log.trace("Condor job " + condorId + " has status " + res);
        return res;
    }

    static {
        statusFlags.put("I", AllocationPhase.SCHEDULED);
        statusFlags.put("R", AllocationPhase.ATTAINED);
        statusFlags.put("X", AllocationPhase.RELEASED);
        statusFlags.put("C", AllocationPhase.RELEASED);
    }
}

