/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.resManagers;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.DriversManager;
import org.gwe.drivers.HandleCreationException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.resManagers.ResourceManagerDriver;
import org.gwe.drivers.resManagers.ResourceManagerHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridResourceManager
extends DriversManager<ResourceManagerDriver<ResourceManagerHandle>, ResourceManagerHandle, NetworkAccessHandle> {
    private static Log log = LogFactory.getLog(GridResourceManager.class);
    private ResourceManagerDriver<ResourceManagerHandle> localRMDriver;

    public GridResourceManager(List<ResourceManagerDriver<ResourceManagerHandle>> drivers) {
        super(drivers);
    }

    private ResourceManagerDriver<ResourceManagerHandle> discoveredLocalResourceManager() throws HandleCreationException {
        if (this.localRMDriver != null) {
            return this.localRMDriver;
        }
        for (ResourceManagerDriver currDriver : this.drivers) {
            log.info("Testing job manager driver '" + currDriver.getClass().getName() + "'");
            if (currDriver.isSupportedJobManagerAvailable()) {
                log.info("Job manager driver '" + currDriver.getClass().getName() + "' detected a manageable Job Manager!");
                this.localRMDriver = currDriver;
                return this.localRMDriver;
            }
            log.info("Job manager driver '" + currDriver.getClass().getName() + "' did not detect a manageable Job Manager...");
        }
        throw new HandleCreationException("None of the registered resource manager drivers was able to find a matching resource manager system installed");
    }

    @Override
    public ResourceManagerHandle createHandle(NetworkAccessHandle conn) throws HandleCreationException {
        try {
            return this.discoveredLocalResourceManager().tryToCreateHandle(conn);
        }
        catch (HandleCreationException e) {
            log.debug("Problem creating a connection to the grid job manager. ", e);
            throw e;
        }
    }
}

