/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.resManagers;

import org.gwe.drivers.Driver;
import org.gwe.drivers.HandleCreationException;
import org.gwe.drivers.netAccess.GridNetworkAccess;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.osAppManagers.GridOSAppManager;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.osAppManagers.MainClass;
import org.gwe.drivers.resManagers.ResourceManagerHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceManagerDriver<HANDLE_TYPE extends ResourceManagerHandle>
extends Driver<HANDLE_TYPE, NetworkAccessHandle> {
    private static Class[] handleConstructorClasses = new Class[]{NetworkAccessHandle.class, JavaOSAppHandle.class};
    protected GridNetworkAccess gridNetworkAccess;
    private GridOSAppManager gridOSAppManager;
    private NetworkAccessHandle localConnection;

    public void setGridNetworkAccess(GridNetworkAccess gridNetworkAccess) {
        this.gridNetworkAccess = gridNetworkAccess;
    }

    public void setGridOSAppManager(GridOSAppManager gridOSAppManager) {
        this.gridOSAppManager = gridOSAppManager;
    }

    public abstract boolean isSupportedJobManagerAvailable();

    @Override
    public Class<NetworkAccessHandle> getHandleParamsClass() {
        return NetworkAccessHandle.class;
    }

    @Override
    public HANDLE_TYPE tryToCreateHandle(NetworkAccessHandle conn) throws HandleCreationException {
        try {
            if (conn == null) {
                if (this.localConnection == null) {
                    this.localConnection = (NetworkAccessHandle)this.gridNetworkAccess.createHandle();
                }
                conn = this.localConnection;
            }
            String appRoot = conn.getLink().getAccountInfo().getHomeDir();
            JavaOSAppHandle agentApp = this.gridOSAppManager.createHandle(appRoot, MainClass.AGENT);
            agentApp.resetDebugPort();
            Object[] constructorParams = new Object[]{conn, agentApp};
            return (HANDLE_TYPE)((ResourceManagerHandle)this.getHandleTypeClass().getConstructor(handleConstructorClasses).newInstance(constructorParams));
        }
        catch (Exception e) {
            throw new HandleCreationException(e);
        }
    }
}

