/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.resManagers;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.resManagers.AllocationPhase;
import org.gwe.drivers.resManagers.ResourceAllocationException;
import org.gwe.persistence.model.AllocationInfo;

public abstract class ResourceManagerHandle {
    private static Log log = LogFactory.getLog(ResourceManagerHandle.class);
    protected NetworkAccessHandle conn;
    protected JavaOSAppHandle agentOSApp;

    public ResourceManagerHandle(NetworkAccessHandle conn, JavaOSAppHandle agentOSApp) {
        this.conn = conn;
        this.agentOSApp = agentOSApp;
    }

    public final AllocationInfo allocateComputeResource(AllocationInfo alloc) throws ResourceAllocationException {
        new File(alloc.getWorkspacePath()).mkdir();
        Object[] agentArgs = alloc.getHeadResource().toAgentArgs(alloc);
        this.agentOSApp.setArgs(agentArgs);
        String launchCmd = this.agentOSApp.getLaunchCommand();
        String systemPid = this.queueAllocationRequest(alloc, launchCmd);
        log.info("Job queued with pid=" + systemPid);
        alloc.setSystemPid(systemPid);
        return alloc;
    }

    protected String[] runQueueCommand(String cmd, AllocationInfo alloc) throws ResourceAllocationException {
        log.trace("Command: " + cmd);
        String path = alloc.getWorkspacePath();
        new File(path).mkdir();
        try {
            String results = "";
            results = this.conn.runCommand(cmd, path, null);
            for (String line : results.split("\n")) {
                log.trace("R: " + line);
            }
            return results.split("\n");
        }
        catch (ConnectorException e) {
            throw new ResourceAllocationException("Could not run queue command '" + cmd + "'", e);
        }
    }

    protected abstract String queueAllocationRequest(AllocationInfo var1, String var2) throws ResourceAllocationException;

    public abstract AllocationPhase killAllocation(AllocationInfo var1) throws ResourceAllocationException;

    public abstract AllocationPhase checkAllocation(AllocationInfo var1) throws ResourceAllocationException;
}

