/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.resManagers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.resManagers.AllocationPhase;
import org.gwe.drivers.resManagers.ResourceAllocationException;
import org.gwe.drivers.resManagers.ResourceManagerHandle;
import org.gwe.persistence.model.AllocationInfo;

class SGEHandle
extends ResourceManagerHandle {
    private static Log log = LogFactory.getLog(SGEHandle.class);
    private static Pattern pattern = Pattern.compile("Your job (\\d+) .* has been submitted");

    public SGEHandle(NetworkAccessHandle conn, JavaOSAppHandle agentOSApp) {
        super(conn, agentOSApp);
    }

    protected String queueAllocationRequest(AllocationInfo alloc, String agentLaunchCmd) throws ResourceAllocationException {
        String[] results = this.runQueueCommand("qsub -S /bin/bash " + agentLaunchCmd, alloc);
        Matcher matcher = pattern.matcher(results[0]);
        return matcher.matches() ? matcher.group(1) : null;
    }

    public AllocationPhase killAllocation(AllocationInfo alloc) throws ResourceAllocationException {
        AllocationPhase stat = this.checkAllocation(alloc);
        if (stat == AllocationPhase.ATTAINED) {
            try {
                this.conn.runCommand("qdel " + alloc.getSystemPid());
            }
            catch (ConnectorException e) {
                throw new ResourceAllocationException("Failed to execute 'qdel' command to kill allocation '" + alloc.getId() + "'", e);
            }
            return AllocationPhase.RELEASED;
        }
        return stat;
    }

    public AllocationPhase checkAllocation(AllocationInfo alloc) throws ResourceAllocationException {
        String[] results;
        String job_id = alloc.getSystemPid();
        if (null == job_id || "null".equals(job_id) || "".equals(job_id)) {
            throw new ResourceAllocationException("Job has no system-level ID; cannot check it.", null);
        }
        try {
            results = this.conn.runCommand("qstat -j " + job_id).split("\n");
        }
        catch (ConnectorException e) {
            throw new ResourceAllocationException("Failed to execute 'qstat' command to check status of allocation '" + alloc.getId() + "'", e);
        }
        boolean finished = false;
        for (String line : results) {
            if (line.matches(".*job_number.*")) {
                finished = true;
                continue;
            }
            if (!line.matches(".*error reason.*")) continue;
            return AllocationPhase.RELEASED;
        }
        if (finished) {
            return AllocationPhase.RELEASED;
        }
        try {
            results = this.conn.runCommand("qacct -j " + job_id).split("\n");
        }
        catch (ConnectorException e) {
            throw new ResourceAllocationException("Faile to execute 'qacct' command to check status of allocation '" + alloc.getId() + "'", e);
        }
        int start = -1;
        for (int idx = results.length - 1; idx >= 0; --idx) {
            if (!results[idx].matches("=*")) continue;
            start = idx;
            break;
        }
        if (start == -1) {
            throw new ResourceAllocationException("Could not find that job in the list of running or completed jobs.", null);
        }
        while (start < results.length) {
            if (results[start].matches("exit_status\\s*0")) {
                return AllocationPhase.RELEASED;
            }
            if (results[start].matches("exit_status")) {
                return AllocationPhase.RELEASED;
            }
            ++start;
        }
        throw new ResourceAllocationException("Could not determine job status for " + job_id + " in SGE.", null);
    }
}

