/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.drivers.resManagers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gwe.drivers.netAccess.ConnectorException;
import org.gwe.drivers.netAccess.NetworkAccessHandle;
import org.gwe.drivers.osAppManagers.JavaOSAppHandle;
import org.gwe.drivers.resManagers.AllocationPhase;
import org.gwe.drivers.resManagers.ResourceAllocationException;
import org.gwe.drivers.resManagers.ResourceManagerHandle;
import org.gwe.persistence.model.AllocationInfo;

class UnixForkHandle
extends ResourceManagerHandle {
    private static Log log = LogFactory.getLog(UnixForkHandle.class);

    public UnixForkHandle(NetworkAccessHandle conn, JavaOSAppHandle agentOSApp) {
        super(conn, agentOSApp);
    }

    protected String queueAllocationRequest(AllocationInfo alloc, String agentLaunchCmd) throws ResourceAllocationException {
        this.runQueueCommand(agentLaunchCmd, alloc);
        try {
            String res = this.conn.runCommand("echo $?");
            log.trace("In PID \"" + res + "\"");
            return res;
        }
        catch (ConnectorException e) {
            throw new ResourceAllocationException("Failed to query system id of allocation '" + alloc.getId() + "'", e);
        }
    }

    public AllocationPhase killAllocation(AllocationInfo alloc) throws ResourceAllocationException {
        AllocationPhase stat = this.checkAllocation(alloc);
        if (stat == AllocationPhase.ATTAINED) {
            try {
                this.conn.runCommand("kill " + alloc.getSystemPid());
            }
            catch (ConnectorException e) {
                throw new ResourceAllocationException("Failed to kill allocation '" + alloc.getId() + "'", e);
            }
            return AllocationPhase.RELEASED;
        }
        return stat;
    }

    public AllocationPhase checkAllocation(AllocationInfo alloc) throws ResourceAllocationException {
        String pid = alloc.getSystemPid();
        if (null == pid || "".equals(pid)) {
            throw new ResourceAllocationException("This job either did not start correctly or was never run.", null);
        }
        try {
            String[] output = this.conn.runCommand("ps " + pid + " | egrep -v \"PID.*COMMAND\"").split("\n");
            return output.length > 0 ? AllocationPhase.ATTAINED : AllocationPhase.RELEASED;
        }
        catch (ConnectorException e) {
            throw new ResourceAllocationException("Failed to check status of allocation '" + alloc.getId() + "'", e);
        }
    }
}

