/*
 * Decompiled with CFR 0.152.
 */
package org.gwe.integration.lddmm;

import java.util.HashMap;
import java.util.Map;
import org.gwe.integration.lddmm.LDDMMParams;
import org.gwe.persistence.model.order.shell.ShellCommandDaemonRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDDMMDaemonRequest
extends ShellCommandDaemonRequest<LDDMMParams> {
    private Map<String, String> env;

    @Override
    protected void setup() {
        this.env = new HashMap<String, String>();
        this.env.put("X509_USER_PROXY", this.createUnderWorkspace("/x509up", ((LDDMMParams)this.parameters).getX509up()));
        this.env.put("LDDMM_HOME", ((LDDMMParams)this.parameters).getLddmmHome());
        this.env.put("SERVER_DN", ((LDDMMParams)this.parameters).getServerDN());
        this.env.put("AUTH_SCHEME", ((LDDMMParams)this.parameters).getAuthScheme());
        this.env.put("mdasDomainName", ((LDDMMParams)this.parameters).getMdasDomainName());
        this.env.put("mdasDomainHome", ((LDDMMParams)this.parameters).getMdasDomainHome());
        this.env.put("srbHost", ((LDDMMParams)this.parameters).getSrbHost());
        this.env.put("srbPort", ((LDDMMParams)this.parameters).getSrbPort());
        this.env.put("srbUser", ((LDDMMParams)this.parameters).getSrbUser());
        this.env.put("defaultResource", ((LDDMMParams)this.parameters).getDefaultResource());
        String atlas = this.getCommandArgument("-A");
        String target = this.getCommandArgument("-T");
        String outDir = ((LDDMMParams)this.parameters).getDestinationFolder();
        if (outDir == null || "".equals(outDir)) {
            outDir = atlas.substring(0, atlas.lastIndexOf(47) + 1) + "results";
        }
        outDir = outDir.replaceAll("srbfile:", "");
        String atlasName = atlas.substring(atlas.lastIndexOf(47));
        String resultDir = outDir + atlasName.substring(0, atlasName.indexOf(46));
        StringBuffer pre = new StringBuffer("#!/bin/bash\n\n");
        pre.append("cd ..\n");
        pre.append("chmod -R go=,u=rwX " + this.workspacePath + "\n\n");
        pre.append(this.getEnvironmentAsString());
        pre.append("ATLAS=" + atlas + "\n");
        pre.append("TARGET=" + target + "\n");
        pre.append("ATLASNAME=$(basename $ATLAS | perl -pe's/\\..*//')\n");
        pre.append("TARGETNAME=$(basename $TARGET | perl -pe's/\\..*//')\n");
        pre.append("DOMAIN=$(echo $ATLAS | perl -pe's/.*\\/" + ((LDDMMParams)this.parameters).getSrbUser() + "\\.([^-]+-[^\\/]+).*/\\1/')\n");
        pre.append("export srbUser=" + ((LDDMMParams)this.parameters).getSrbUser() + "\n");
        pre.append("export mdasDomainName=$DOMAIN\n");
        pre.append("export mdasDomainHome=$DOMAIN\n");
        pre.append("export SRB_HOME=/usr/local/bin/srb34/\n");
        pre.append("Smkdir " + outDir + "\n");
        pre.append("Smkdir " + resultDir + "\n");
        pre.append("printenv\n\n");
        String configPath = this.createUnderWorkspace("/lddmm-config.txt", ((LDDMMParams)this.parameters).getLddmmConfig());
        pre.append(this.localizedCmd + " -o srbdir:" + resultDir + " -m -c " + configPath + "\n");
        this.localizedCmd = "sh " + this.createUnderWorkspace("/job.sh", pre.toString());
    }

    @Override
    protected Map<String, String> getEnvironment() {
        return this.env;
    }

    private String getEnvironmentAsString() {
        String result = "";
        for (String key : this.env.keySet()) {
            result = result + "export " + key + "=" + this.env.get(key) + "\n";
        }
        return result;
    }

    @Override
    protected void tearDown() {
    }

    private String getCommandArgument(String argType) {
        String[] args = this.localizedCmd.split("\\s+");
        for (int idx = 0; idx < args.length; ++idx) {
            if (!argType.equals(args[idx])) continue;
            return args[++idx];
        }
        return "undefined";
    }
}

